/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.entity.custom;

import com.mafuyu33.mafishcrossbow.entity.TrailEntity;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.decreaselifetime.DecreaseLifetimeHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.increaselifetime.IncreaseLifetimeHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class TotemProjectile
extends TrailEntity {
    private static final EntityDataAccessor<Integer> FIELD_DURATION = SynchedEntityData.defineId(TotemProjectile.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> FIELD_ACTIVE = SynchedEntityData.defineId(TotemProjectile.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<BlockPos> FIELD_CENTER = SynchedEntityData.defineId(TotemProjectile.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);
    private static final float FIELD_RADIUS = 5.0f;
    private static final int BASE_DURATION = 200;
    private static final float TOTEM_HEIGHT = 3.0f;
    private int ticksInField = 0;
    private BlockPos fieldCenter = null;

    public TotemProjectile(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
        this.setNoGravity(false);
    }

    public TotemProjectile(EntityType<? extends ThrowableItemProjectile> entityType, LivingEntity owner, Level level, ItemStack item, Vec3 startPos) {
        super(entityType, owner, level, item);
        this.setNoGravity(false);
        this.setPos(startPos);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FIELD_DURATION, (Object)200);
        builder.define(FIELD_ACTIVE, (Object)false);
        builder.define(FIELD_CENTER, (Object)BlockPos.ZERO);
    }

    protected Item getDefaultItem() {
        return Items.TOTEM_OF_UNDYING;
    }

    @Override
    public void tick() {
        if (((Boolean)this.entityData.get(FIELD_ACTIVE)).booleanValue()) {
            ++this.ticksInField;
            if (this.fieldCenter != null) {
                Vec3 fixedPos = Vec3.atCenterOf((Vec3i)this.fieldCenter).add(0.0, 3.0, 0.0);
                this.setPos(fixedPos);
                this.setDeltaMovement(Vec3.ZERO);
            }
            if (!this.level().isClientSide) {
                this.handleFieldEffects();
                if (this.ticksInField >= (Integer)this.entityData.get(FIELD_DURATION)) {
                    this.discard();
                    return;
                }
            }
            if (this.ticksInField < (Integer)this.entityData.get(FIELD_DURATION) - 35) {
                this.spawnFieldParticles();
            }
        } else {
            super.tick();
        }
    }

    @Override
    protected void afterHitBlock(BlockHitResult result) {
        if (!this.level().isClientSide && !((Boolean)this.entityData.get(FIELD_ACTIVE)).booleanValue()) {
            this.activateField(result.getBlockPos().above());
        }
    }

    @Override
    protected void onHitEntity(EntityHitResult result) {
        if (!this.level().isClientSide && !((Boolean)this.entityData.get(FIELD_ACTIVE)).booleanValue()) {
            this.activateField(result.getEntity().blockPosition());
        }
    }

    private void activateField(BlockPos centerPos) {
        this.fieldCenter = centerPos;
        this.entityData.set(FIELD_CENTER, (Object)centerPos);
        this.entityData.set(FIELD_ACTIVE, (Object)true);
        int finalDuration = 200;
        finalDuration = IncreaseLifetimeHelper.modifyMaxLifetime((Entity)this, finalDuration, this.getPersistentData());
        finalDuration = DecreaseLifetimeHelper.modifyMaxLifetime((Entity)this, finalDuration, this.getPersistentData());
        this.entityData.set(FIELD_DURATION, (Object)Math.max(40, finalDuration));
        Vec3 totemPos = Vec3.atCenterOf((Vec3i)centerPos).add(0.0, 3.0, 0.0);
        this.setPos(totemPos);
        this.setDeltaMovement(Vec3.ZERO);
        this.setNoGravity(true);
        this.level().playSound(null, totemPos.x, totemPos.y, totemPos.z, SoundEvents.EVOKER_CAST_SPELL, SoundSource.NEUTRAL, 1.5f, 1.5f);
    }

    private void handleFieldEffects() {
        if (this.fieldCenter == null) {
            return;
        }
        Vec3 center = Vec3.atCenterOf((Vec3i)this.fieldCenter);
        AABB fieldBounds = new AABB(center.x - 5.0, (double)(this.fieldCenter.getY() - 1), center.z - 5.0, center.x + 5.0, (double)((float)this.fieldCenter.getY() + 3.0f + 1.0f), center.z + 5.0);
        List entities = this.level().getEntitiesOfClass(LivingEntity.class, fieldBounds);
        for (LivingEntity entity : entities) {
            double dz;
            double dx = entity.getX() - center.x;
            double distanceSq = dx * dx + (dz = entity.getZ() - center.z) * dz;
            if (!(distanceSq <= 25.0)) continue;
            CompoundTag tag = entity.getPersistentData();
            tag.putBoolean("TotemFieldProtection", true);
            tag.putInt("TotemFieldTicks", 2);
            entity.setGlowingTag(true);
        }
    }

    private void spawnFieldParticles() {
        if (this.fieldCenter == null) {
            return;
        }
        Vec3 totemPos = Vec3.atCenterOf((Vec3i)this.fieldCenter).add(0.0, 3.0, 0.0);
        Level level = this.level();
        if (level instanceof ServerLevel) {
            double z;
            double x;
            double angle;
            int i;
            ServerLevel serverLevel = (ServerLevel)level;
            for (i = 0; i < 8; ++i) {
                angle = Math.PI * 2 * (double)i / 8.0 + (double)this.ticksInField * 0.02;
                x = totemPos.x + Math.cos(angle) * 5.0;
                z = totemPos.z + Math.sin(angle) * 5.0;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, x, totemPos.y, z, 1, 0.2, 0.2, 0.2, 0.0);
            }
            for (i = 0; i < 16; ++i) {
                angle = Math.PI * 2 * (double)i / 16.0 + (double)this.ticksInField * 0.2;
                x = totemPos.x + Math.cos(angle) * 5.0;
                z = totemPos.z + Math.sin(angle) * 5.0;
                if (this.ticksInField % 10 != i % 10) continue;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, x, (double)this.fieldCenter.getY() + 0.1, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void updateRotation() {
        if (!((Boolean)this.entityData.get(FIELD_ACTIVE)).booleanValue()) {
            super.updateRotation();
        }
    }

    public boolean isPushable() {
        return (Boolean)this.entityData.get(FIELD_ACTIVE) == false;
    }

    public void push(double x, double y, double z) {
        if (!((Boolean)this.entityData.get(FIELD_ACTIVE)).booleanValue()) {
            super.push(x, y, z);
        }
    }

    public boolean isPickable() {
        return (Boolean)this.entityData.get(FIELD_ACTIVE) == false;
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        super.addAdditionalSaveData(output);
        output.putBoolean("FieldActive", ((Boolean)this.entityData.get(FIELD_ACTIVE)).booleanValue());
        output.putInt("FieldDuration", ((Integer)this.entityData.get(FIELD_DURATION)).intValue());
        output.putInt("TicksInField", this.ticksInField);
        if (this.fieldCenter != null) {
            output.putInt("FieldCenterX", this.fieldCenter.getX());
            output.putInt("FieldCenterY", this.fieldCenter.getY());
            output.putInt("FieldCenterZ", this.fieldCenter.getZ());
        }
    }

    protected void readAdditionalSaveData(ValueInput input) {
        super.readAdditionalSaveData(input);
        boolean isActive = input.getBooleanOr("FieldActive", false);
        this.entityData.set(FIELD_ACTIVE, (Object)isActive);
        this.entityData.set(FIELD_DURATION, (Object)input.getIntOr("FieldDuration", 200));
        this.ticksInField = input.getIntOr("TicksInField", 0);
        int x = input.getIntOr("FieldCenterX", Integer.MIN_VALUE);
        int y = input.getIntOr("FieldCenterY", Integer.MIN_VALUE);
        int z = input.getIntOr("FieldCenterZ", Integer.MIN_VALUE);
        if (x != Integer.MIN_VALUE && y != Integer.MIN_VALUE && z != Integer.MIN_VALUE) {
            this.fieldCenter = new BlockPos(x, y, z);
            this.entityData.set(FIELD_CENTER, (Object)this.fieldCenter);
            if (isActive) {
                Vec3 totemPos = Vec3.atCenterOf((Vec3i)this.fieldCenter).add(0.0, 3.0, 0.0);
                this.setPos(totemPos);
                this.setDeltaMovement(Vec3.ZERO);
                this.setNoGravity(true);
            }
        }
    }

    public boolean isCurrentlyGlowing() {
        return false;
    }
}

