/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.entity.renderer;

import com.mafuyu33.mafishcrossbow.entity.custom.CustomFallingBlockEntity;
import com.mafuyu33.mafishcrossbow.entity.renderer.CustomFallingBlockRenderState;
import com.mafuyu33.mafishcrossbow.util.StructureBlockHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.RenderTypeHelper;

public class CustomFallingBlockRenderer
extends EntityRenderer<CustomFallingBlockEntity, CustomFallingBlockRenderState> {
    private final BlockRenderDispatcher dispatcher;

    public CustomFallingBlockRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.5f;
        this.dispatcher = context.getBlockRenderDispatcher();
    }

    public void render(CustomFallingBlockRenderState state, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        BlockState blockState = state.blockState;
        BlockRenderDispatcher dispatcher = this.dispatcher;
        RenderShape renderShape = blockState.getRenderShape();
        if (renderShape != RenderShape.INVISIBLE) {
            block6: {
                poseStack.pushPose();
                poseStack.translate(-0.5, 0.0, -0.5);
                if (blockState.hasBlockEntity()) {
                    // empty if block
                }
                BlockStateModel blockModel = dispatcher.getBlockModel(blockState);
                List modelParts = blockModel.collectParts(state.level, state.blockPos, blockState, RandomSource.create((long)blockState.getSeed(state.startBlockPos)));
                try {
                    dispatcher.renderSingleBlock(blockState, poseStack, bufferSource, packedLight, OverlayTexture.NO_OVERLAY);
                }
                catch (Exception e) {
                    if (modelParts.isEmpty()) break block6;
                    dispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)state, modelParts, blockState, state.blockPos, poseStack, renderType -> bufferSource.getBuffer(RenderTypeHelper.getMovingBlockRenderType((ChunkSectionLayer)renderType)), false, OverlayTexture.NO_OVERLAY);
                }
            }
            poseStack.popPose();
        }
        if (state.otherHalfState != null && state.otherHalfState.getRenderShape() != RenderShape.INVISIBLE) {
            poseStack.pushPose();
            BlockPos renderOffset = StructureBlockHelper.getRenderOffset(state.blockState, state.otherHalfState);
            poseStack.translate(-0.5 + (double)renderOffset.getX(), (double)renderOffset.getY(), -0.5 + (double)renderOffset.getZ());
            BlockPos otherPos = state.blockPos.offset((Vec3i)renderOffset);
            BlockStateModel blockModel = dispatcher.getBlockModel(state.otherHalfState);
            List modelParts = blockModel.collectParts(state.level, otherPos, state.otherHalfState, RandomSource.create((long)state.otherHalfState.getSeed(state.startBlockPos)));
            if (!modelParts.isEmpty()) {
                dispatcher.getModelRenderer().tesselateBlock((BlockAndTintGetter)state, modelParts, state.otherHalfState, otherPos, poseStack, renderType -> bufferSource.getBuffer(RenderTypeHelper.getMovingBlockRenderType((ChunkSectionLayer)renderType)), false, OverlayTexture.NO_OVERLAY);
            }
            poseStack.popPose();
        }
        super.render((EntityRenderState)state, poseStack, bufferSource, packedLight);
    }

    public CustomFallingBlockRenderState createRenderState() {
        return new CustomFallingBlockRenderState();
    }

    public void extractRenderState(CustomFallingBlockEntity entity, CustomFallingBlockRenderState state, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)state, partialTick);
        BlockPos blockPos = BlockPos.containing((double)entity.getX(), (double)entity.getBoundingBox().maxY, (double)entity.getZ());
        BlockState main = entity.getBlockState();
        state.startBlockPos = entity.getStartPos();
        state.blockPos = blockPos;
        state.blockState = main;
        state.biome = entity.level().getBiome(blockPos);
        state.level = entity.level();
        state.otherHalfState = entity.getOtherHalfState();
    }
}

