/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.entity.renderer;

import com.mafuyu33.mafishcrossbow.entity.custom.CustomLightningBoltEntity;
import com.mafuyu33.mafishcrossbow.entity.renderer.CustomLightningBoltRenderState;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class CustomLightningBoltRenderer
extends EntityRenderer<CustomLightningBoltEntity, CustomLightningBoltRenderState> {
    public CustomLightningBoltRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.0f;
        this.shadowStrength = 0.0f;
    }

    public void render(CustomLightningBoltRenderState renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (!renderState.hasStruck || renderState.pathPoints == null || renderState.pathPoints.size() < 1) {
            return;
        }
        poseStack.pushPose();
        poseStack.translate(-renderState.x, -renderState.y, -renderState.z);
        Matrix4f matrix4f = poseStack.last().pose();
        this.renderLightningPath(matrix4f, bufferSource, renderState.pathPoints, renderState.seed, renderState.strikeProgress, packedLight);
        poseStack.popPose();
    }

    private void renderLightningPath(Matrix4f matrix, MultiBufferSource bufferSource, List<Vec3> pathPoints, long seed, float progress, int packedLight) {
        if (pathPoints.size() < 1) {
            return;
        }
        List<Vec3> detailedPath = this.generateDetailedLightningPath(pathPoints, seed);
        float opacity = 1.0f - progress / 20.0f;
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.lightning());
        this.renderLightningBolt(matrix, buffer, detailedPath, seed, opacity);
    }

    private List<Vec3> generateDetailedLightningPath(List<Vec3> pathPoints, long seed) {
        ArrayList<Vec3> detailed = new ArrayList<Vec3>();
        RandomSource random = RandomSource.create((long)seed);
        if (pathPoints.isEmpty()) {
            return detailed;
        }
        if (pathPoints.size() == 1) {
            detailed.add(pathPoints.get(0));
            return detailed;
        }
        for (int i = 0; i < pathPoints.size() - 1; ++i) {
            Vec3 start = pathPoints.get(i);
            Vec3 end = pathPoints.get(i + 1);
            Vec3 direction = end.subtract(start);
            double distance = direction.length();
            int segments = Math.max(1, Math.min(20, (int)(distance / 0.3)));
            for (int j = 0; j <= segments; ++j) {
                double t = (double)j / (double)segments;
                Vec3 basePoint = start.add(direction.scale(t));
                if (j != 0 && j != segments && i > 0) {
                    double offset = 0.05 + random.nextDouble() * 0.1;
                    basePoint = basePoint.add((random.nextDouble() - 0.5) * offset, (random.nextDouble() - 0.5) * offset * 0.3, (random.nextDouble() - 0.5) * offset);
                }
                detailed.add(basePoint);
            }
        }
        return detailed;
    }

    private void renderLightningBolt(Matrix4f matrix, VertexConsumer buffer, List<Vec3> path, long seed, float opacity) {
        if (path.size() < 2) {
            return;
        }
        RandomSource flicker = RandomSource.create((long)(seed + System.currentTimeMillis() / 100L));
        float flickerFactor = 0.7f + flicker.nextFloat() * 0.3f;
        opacity *= flickerFactor;
        if (flickerFactor < 0.75f && flicker.nextFloat() < 0.3f) {
            return;
        }
        for (int i = 0; i < path.size() - 1; ++i) {
            Vec3 start = path.get(i);
            Vec3 end = path.get(i + 1);
            this.renderLightningSegment(matrix, buffer, start, end, seed + (long)i, opacity);
        }
        RandomSource random = RandomSource.create((long)seed);
        int branchCount = 2 + random.nextInt(3);
        for (int i = 0; i < branchCount && path.size() > 2; ++i) {
            int index = random.nextInt(path.size() - 1);
            Vec3 branchStart = path.get(index);
            float angle = random.nextFloat() * (float)Math.PI * 2.0f;
            float length = 1.0f + random.nextFloat() * 2.0f;
            Vec3 branchEnd = branchStart.add(Math.cos(angle) * (double)length, (double)(-0.5f - random.nextFloat()), Math.sin(angle) * (double)length);
            this.renderLightningSegment(matrix, buffer, branchStart, branchEnd, seed + 1000L + (long)i, opacity * 0.5f);
        }
    }

    private void renderLightningSegment(Matrix4f matrix, VertexConsumer buffer, Vec3 start, Vec3 end, long seed, float opacity) {
        for (int layer = 0; layer < 4; ++layer) {
            float layerProgress = (float)layer / 3.0f;
            float layerOpacity = opacity * (1.0f - layerProgress * 0.6f);
            float size = 0.05f + (float)layer * 0.08f;
            float r = 1.0f - layerProgress * 0.2f;
            float g = 1.0f - layerProgress * 0.4f;
            float b = 1.0f;
            this.renderLightningLayer(matrix, buffer, start, end, r, g, b, layerOpacity, size);
            if (layer != 0) continue;
            this.renderLightningLayer(matrix, buffer, start, end, 1.0f, 1.0f, 1.0f, layerOpacity * 0.9f, size * 0.5f);
        }
    }

    private void renderLightningLayer(Matrix4f matrix, VertexConsumer buffer, Vec3 start, Vec3 end, float r, float g, float b, float a, float size) {
        Vec3 dir = end.subtract(start);
        double length = dir.length();
        if (length < 0.001) {
            return;
        }
        float dx = (float)(end.x - start.x);
        float dy = (float)(end.y - start.y);
        float dz = (float)(end.z - start.z);
        this.renderLightningQuadFace(matrix, buffer, (float)start.x, (float)start.y, (float)start.z, (float)end.x, (float)end.y, (float)end.z, r, g, b, a, size, size, true, true, false, true);
        this.renderLightningQuadFace(matrix, buffer, (float)start.x, (float)start.y, (float)start.z, (float)end.x, (float)end.y, (float)end.z, r, g, b, a, size, size, false, true, false, false);
        this.renderLightningQuadFace(matrix, buffer, (float)start.x, (float)start.y, (float)start.z, (float)end.x, (float)end.y, (float)end.z, r, g, b, a, size, size, false, false, true, false);
        this.renderLightningQuadFace(matrix, buffer, (float)start.x, (float)start.y, (float)start.z, (float)end.x, (float)end.y, (float)end.z, r, g, b, a, size, size, true, false, true, true);
    }

    private void renderLightningQuadFace(Matrix4f pose, VertexConsumer buffer, float x1, float y1, float z1, float x2, float y2, float z2, float red, float green, float blue, float alpha, float startThickness, float endThickness, boolean addThicknessLeftSideX, boolean addThicknessLeftSideZ, boolean addThicknessRightSideX, boolean addThicknessRightSideZ) {
        buffer.addVertex(pose, x1 + (addThicknessLeftSideX ? startThickness : -startThickness), y1, z1 + (addThicknessLeftSideZ ? startThickness : -startThickness)).setColor(red, green, blue, alpha);
        buffer.addVertex(pose, x2 + (addThicknessLeftSideX ? endThickness : -endThickness), y2, z2 + (addThicknessLeftSideZ ? endThickness : -endThickness)).setColor(red, green, blue, alpha);
        buffer.addVertex(pose, x2 + (addThicknessRightSideX ? endThickness : -endThickness), y2, z2 + (addThicknessRightSideZ ? endThickness : -endThickness)).setColor(red, green, blue, alpha);
        buffer.addVertex(pose, x1 + (addThicknessRightSideX ? startThickness : -startThickness), y1, z1 + (addThicknessRightSideZ ? startThickness : -startThickness)).setColor(red, green, blue, alpha);
    }

    private void renderLightningQuad(Matrix4f matrix, VertexConsumer buffer, Vec3 start, Vec3 end, int layer, float opacity) {
        float brightness = 1.0f - (float)layer * 0.2f;
        float red = 0.45f * brightness;
        float green = 0.45f * brightness;
        float blue = 0.5f * brightness;
        float alpha = 0.3f * opacity * (1.0f - (float)layer * 0.2f);
        float size = 0.5f + (float)layer * 0.2f;
        float adjustedSize = size * 0.8f;
        this.renderQuadStrip(matrix, buffer, (float)start.x, (float)start.y - adjustedSize, (float)start.z, (float)start.x, (float)start.y + adjustedSize, (float)start.z, (float)end.x, (float)end.y + adjustedSize, (float)end.z, (float)end.x, (float)end.y - size, (float)end.z, red, green, blue, alpha);
        this.renderQuadStrip(matrix, buffer, (float)start.x, (float)start.y, (float)start.z - size, (float)start.x, (float)start.y, (float)start.z + size, (float)end.x, (float)end.y, (float)end.z + size, (float)end.x, (float)end.y, (float)end.z - size, red, green, blue, alpha);
        float diag = size * 0.707f;
        this.renderQuadStrip(matrix, buffer, (float)start.x - diag, (float)start.y - diag, (float)start.z, (float)start.x + diag, (float)start.y + diag, (float)start.z, (float)end.x + diag, (float)end.y + diag, (float)end.z, (float)end.x - diag, (float)end.y - diag, (float)end.z, red, green, blue, alpha);
        this.renderQuadStrip(matrix, buffer, (float)start.x, (float)start.y - diag, (float)start.z - diag, (float)start.x, (float)start.y + diag, (float)start.z + diag, (float)end.x, (float)end.y + diag, (float)end.z + diag, (float)end.x, (float)end.y - diag, (float)end.z - diag, red, green, blue, alpha);
    }

    private void renderQuadStrip(Matrix4f matrix, VertexConsumer buffer, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4, float r, float g, float b, float a) {
        buffer.addVertex(matrix, x1, y1, z1).setColor(r, g, b, a);
        buffer.addVertex(matrix, x2, y2, z2).setColor(r, g, b, a);
        buffer.addVertex(matrix, x3, y3, z3).setColor(r, g, b, a);
        buffer.addVertex(matrix, x4, y4, z4).setColor(r, g, b, a);
    }

    private void renderLightningCore(Matrix4f matrix, VertexConsumer buffer, List<Vec3> path, long seed, float opacity) {
        for (int i = 0; i < path.size() - 1; ++i) {
            Vec3 start = path.get(i);
            Vec3 end = path.get(i + 1);
            float brightness = opacity;
            buffer.addVertex(matrix, (float)start.x, (float)start.y, (float)start.z).setColor(brightness, brightness, brightness * 1.2f, opacity).setNormal(0.0f, 1.0f, 0.0f);
            buffer.addVertex(matrix, (float)end.x, (float)end.y, (float)end.z).setColor(brightness, brightness, brightness * 1.2f, opacity).setNormal(0.0f, 1.0f, 0.0f);
        }
    }

    private void renderLightningBody(Matrix4f matrix, VertexConsumer buffer, List<Vec3> path, long seed, float opacity, int packedLight) {
        RandomSource random = RandomSource.create((long)seed);
        for (int i = 0; i < path.size() - 1; ++i) {
            Vec3 start = path.get(i);
            Vec3 end = path.get(i + 1);
            float r = 0.7f;
            float g = 0.8f;
            float b = 1.0f;
            for (int layer = 0; layer < 2; ++layer) {
                float thickness = (0.3f + (float)layer * 0.2f) * (1.0f + random.nextFloat() * 0.3f);
                float layerAlpha = opacity * (1.0f - (float)layer * 0.3f);
                this.renderSimpleQuad(matrix, buffer, start, end, r, g, b, layerAlpha, thickness);
            }
        }
    }

    private void renderSimpleQuad(Matrix4f matrix, VertexConsumer buffer, Vec3 start, Vec3 end, float r, float g, float b, float alpha, float thickness) {
        Vec3 direction = end.subtract(start).normalize();
        Vec3 up = new Vec3(0.0, 1.0, 0.0);
        Vec3 side = direction.cross(up).normalize().scale((double)thickness);
        if (Math.abs(direction.dot(up)) > 0.9) {
            side = new Vec3(1.0, 0.0, 0.0).scale((double)thickness);
        }
        Vec3 v1 = start.add(side);
        Vec3 v2 = start.subtract(side);
        Vec3 v3 = end.subtract(side);
        Vec3 v4 = end.add(side);
        buffer.addVertex(matrix, (float)v1.x, (float)v1.y, (float)v1.z).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv1(240, 240).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
        buffer.addVertex(matrix, (float)v2.x, (float)v2.y, (float)v2.z).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv1(240, 240).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
        buffer.addVertex(matrix, (float)v3.x, (float)v3.y, (float)v3.z).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv1(240, 240).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
        buffer.addVertex(matrix, (float)v4.x, (float)v4.y, (float)v4.z).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv1(240, 240).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
    }

    private void renderSimpleLightning(Matrix4f matrix, VertexConsumer buffer, List<Vec3> path, long seed, float opacity, int packedLight) {
        RandomSource random = RandomSource.create((long)seed);
        for (int layer = 0; layer < 3; ++layer) {
            float layerOpacity = opacity * (1.0f - (float)layer * 0.2f);
            float thickness = 0.4f * (1.0f - (float)layer * 0.2f);
            float r = layer == 0 ? 0.9f : 0.6f;
            float g = layer == 0 ? 0.9f : 0.6f;
            float b = 1.0f;
            for (int i = 0; i < path.size() - 1; ++i) {
                Vec3 start = path.get(i);
                Vec3 end = path.get(i + 1);
                if (layer > 0) {
                    float offset = 0.05f * (float)layer;
                    start = start.add((double)((random.nextFloat() - 0.5f) * offset), (double)((random.nextFloat() - 0.5f) * offset), (double)((random.nextFloat() - 0.5f) * offset));
                    end = end.add((double)((random.nextFloat() - 0.5f) * offset), (double)((random.nextFloat() - 0.5f) * offset), (double)((random.nextFloat() - 0.5f) * offset));
                }
                this.renderLightningSegment(matrix, buffer, start, end, r, g, b, layerOpacity, thickness, packedLight);
            }
        }
        float glowR = 0.4f;
        float glowG = 0.4f;
        float glowB = 0.9f;
        float glowAlpha = opacity * 0.2f;
        float glowThickness = 1.5f;
        for (int i = 0; i < path.size() - 1; ++i) {
            Vec3 start = path.get(i);
            Vec3 end = path.get(i + 1);
            this.renderLightningSegment(matrix, buffer, start, end, glowR, glowG, glowB, glowAlpha, glowThickness, packedLight);
        }
    }

    private void renderLightningSegment(Matrix4f matrix, VertexConsumer buffer, Vec3 start, Vec3 end, float r, float g, float b, float alpha, float thickness, int light) {
        Vec3 direction = end.subtract(start);
        double length = direction.length();
        if (length < 0.001) {
            return;
        }
        direction = direction.normalize();
        Vec3 cameraRight = new Vec3(1.0, 0.0, 0.0);
        Vec3 offset = cameraRight.scale((double)thickness);
        Vec3 v1 = start.add(offset);
        Vec3 v2 = start.subtract(offset);
        Vec3 v3 = end.subtract(offset);
        Vec3 v4 = end.add(offset);
        buffer.addVertex(matrix, (float)v1.x, (float)v1.y, (float)v1.z).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv1(240, 240).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
        buffer.addVertex(matrix, (float)v2.x, (float)v2.y, (float)v2.z).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv1(240, 240).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
        buffer.addVertex(matrix, (float)v3.x, (float)v3.y, (float)v3.z).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv1(240, 240).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
        buffer.addVertex(matrix, (float)v4.x, (float)v4.y, (float)v4.z).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv1(240, 240).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
        Vec3 verticalOffset = new Vec3(0.0, (double)thickness, 0.0);
        v1 = start.add(verticalOffset);
        v2 = start.subtract(verticalOffset);
        v3 = end.subtract(verticalOffset);
        v4 = end.add(verticalOffset);
        buffer.addVertex(matrix, (float)v1.x, (float)v1.y, (float)v1.z).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setUv1(240, 240).setLight(0xF000F0).setNormal(1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, (float)v2.x, (float)v2.y, (float)v2.z).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setUv1(240, 240).setLight(0xF000F0).setNormal(1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, (float)v3.x, (float)v3.y, (float)v3.z).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setUv1(240, 240).setLight(0xF000F0).setNormal(1.0f, 0.0f, 0.0f);
        buffer.addVertex(matrix, (float)v4.x, (float)v4.y, (float)v4.z).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setUv1(240, 240).setLight(0xF000F0).setNormal(1.0f, 0.0f, 0.0f);
    }

    private void renderLightningLines(Matrix4f matrix, VertexConsumer buffer, List<Vec3> path, float opacity) {
        float brightness = opacity;
        for (int i = 0; i < path.size() - 1; ++i) {
            Vec3 start = path.get(i);
            Vec3 end = path.get(i + 1);
            buffer.addVertex(matrix, (float)start.x, (float)start.y, (float)start.z).setColor(brightness, brightness, brightness, opacity).setNormal(0.0f, 1.0f, 0.0f);
            buffer.addVertex(matrix, (float)end.x, (float)end.y, (float)end.z).setColor(brightness, brightness, brightness, opacity).setNormal(0.0f, 1.0f, 0.0f);
        }
    }

    private void renderLightningGlow(Matrix4f matrix, VertexConsumer buffer, List<Vec3> path, long seed, float opacity) {
        RandomSource random = RandomSource.create((long)seed);
        float thickness = 1.0f;
        for (int i = 0; i < path.size() - 1; ++i) {
            Vec3 start = path.get(i);
            Vec3 end = path.get(i + 1);
            float r = 0.5f;
            float g = 0.5f;
            float b = 1.0f;
            this.renderGlowStrip(matrix, buffer, start, end, r, g, b, opacity * 0.3f, thickness);
        }
    }

    private void renderVerticalStrip(Matrix4f matrix, VertexConsumer buffer, Vec3 start, Vec3 end, float r, float g, float b, float alpha, float thickness, int light) {
        Vec3 up = new Vec3(0.0, 1.0, 0.0);
        Vec3 direction = end.subtract(start).normalize();
        Vec3 side = direction.cross(up).normalize().scale((double)thickness);
        if (Math.abs(direction.dot(up)) > 0.9) {
            side = new Vec3(1.0, 0.0, 0.0).scale((double)thickness);
        }
        Vec3 s1 = start.add(side);
        Vec3 s2 = start.subtract(side);
        Vec3 e1 = end.add(side);
        Vec3 e2 = end.subtract(side);
        buffer.addVertex(matrix, (float)s1.x, (float)s1.y, (float)s1.z).setColor(r, g, b, alpha).setUv(0.0f, 0.0f).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
        buffer.addVertex(matrix, (float)e1.x, (float)e1.y, (float)e1.z).setColor(r, g, b, alpha).setUv(1.0f, 0.0f).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
        buffer.addVertex(matrix, (float)e2.x, (float)e2.y, (float)e2.z).setColor(r, g, b, alpha).setUv(1.0f, 1.0f).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
        buffer.addVertex(matrix, (float)s2.x, (float)s2.y, (float)s2.z).setColor(r, g, b, alpha).setUv(0.0f, 1.0f).setLight(light).setNormal(0.0f, 1.0f, 0.0f);
    }

    private void renderGlowStrip(Matrix4f matrix, VertexConsumer buffer, Vec3 start, Vec3 end, float r, float g, float b, float alpha, float thickness) {
        Vec3 direction = end.subtract(start).normalize();
        Vec3 up = new Vec3(0.0, 1.0, 0.0);
        Vec3 side = direction.cross(up).normalize().scale((double)thickness);
        if (Math.abs(direction.dot(up)) > 0.9) {
            side = new Vec3(1.0, 0.0, 0.0).scale((double)thickness);
        }
        Vec3 s1 = start.add(side);
        Vec3 s2 = start.subtract(side);
        Vec3 e1 = end.add(side);
        Vec3 e2 = end.subtract(side);
        buffer.addVertex(matrix, (float)s1.x, (float)s1.y, (float)s1.z).setColor(r, g, b, alpha).setUv(0.0f, 0.0f);
        buffer.addVertex(matrix, (float)e1.x, (float)e1.y, (float)e1.z).setColor(r, g, b, alpha).setUv(1.0f, 0.0f);
        buffer.addVertex(matrix, (float)e2.x, (float)e2.y, (float)e2.z).setColor(r, g, b, alpha).setUv(1.0f, 1.0f);
        buffer.addVertex(matrix, (float)s2.x, (float)s2.y, (float)s2.z).setColor(r, g, b, alpha).setUv(0.0f, 1.0f);
    }

    private void renderBoltSegment(Matrix4f matrix, VertexConsumer buffer, float x1, float y1, float z1, float x2, float y2, float z2, float thickness, float opacity, boolean isMainLayer) {
        float brightness = isMainLayer ? 1.0f : 0.7f;
        float red = 0.65f * brightness;
        float green = 0.65f * brightness;
        float blue = 1.0f * brightness;
        float alpha = opacity * (isMainLayer ? 0.9f : 0.5f);
        this.renderVerticalBolt(matrix, buffer, x1, y1, z1, x2, y2, z2, red, green, blue, alpha, thickness);
    }

    private void renderVerticalBolt(Matrix4f matrix, VertexConsumer buffer, float x1, float y1, float z1, float x2, float y2, float z2, float red, float green, float blue, float alpha, float thickness) {
        RandomSource random = RandomSource.create((long)((long)(x1 * 1000.0f + y1 * 1000.0f + z1 * 1000.0f)));
        float distance = (float)Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1) + (z2 - z1) * (z2 - z1));
        int segments = Math.max(1, (int)(distance / 0.2f));
        for (int i = 0; i <= segments; ++i) {
            float t = (float)i / (float)Math.max(1, segments);
            float px = x1 + (x2 - x1) * t;
            float py = y1 + (y2 - y1) * t;
            float pz = z1 + (z2 - z1) * t;
            float jitter = thickness * 0.5f;
            float boltHeight = thickness * (0.8f + random.nextFloat() * 0.4f);
            this.renderLightningQuad(matrix, buffer, px += (random.nextFloat() - 0.5f) * jitter, py += (random.nextFloat() - 0.5f) * jitter * 0.3f, pz += (random.nextFloat() - 0.5f) * jitter, red, green, blue, alpha, thickness, boltHeight);
        }
    }

    private void renderLightningQuad(Matrix4f matrix, VertexConsumer buffer, float centerX, float centerY, float centerZ, float red, float green, float blue, float alpha, float thickness, float height) {
        float halfThickness = thickness * 0.5f;
        float halfHeight = height * 0.5f;
        CustomLightningBoltRenderer.quad(matrix, buffer, centerX + halfThickness, centerY - halfHeight, centerZ, centerX + halfThickness, centerY + halfHeight, centerZ, red, green, blue, alpha, halfThickness, false, false, true, false);
        CustomLightningBoltRenderer.quad(matrix, buffer, centerX - halfThickness, centerY + halfHeight, centerZ, centerX - halfThickness, centerY - halfHeight, centerZ, red, green, blue, alpha, halfThickness, true, false, true, true);
        CustomLightningBoltRenderer.quad(matrix, buffer, centerX, centerY - halfHeight, centerZ + halfThickness, centerX, centerY + halfHeight, centerZ + halfThickness, red, green, blue, alpha, halfThickness, true, true, false, true);
        CustomLightningBoltRenderer.quad(matrix, buffer, centerX, centerY + halfHeight, centerZ - halfThickness, centerX, centerY - halfHeight, centerZ - halfThickness, red, green, blue, alpha, halfThickness, false, true, false, false);
    }

    private void renderCylindricalSegment(Matrix4f matrix, VertexConsumer buffer, float x1, float y1, float z1, float x2, float y2, float z2, float red, float green, float blue, float alpha, float radius) {
        float uz;
        float uy;
        float ux;
        float dx = x2 - x1;
        float dy = y2 - y1;
        float dz = z2 - z1;
        float length = (float)Math.sqrt(dx * dx + dy * dy + dz * dz);
        if (length < 0.001f) {
            return;
        }
        dx /= length;
        dy /= length;
        dz /= length;
        if (Math.abs(dy) > 0.9f) {
            ux = 1.0f;
            uy = 0.0f;
            uz = 0.0f;
        } else {
            ux = 0.0f;
            uy = 1.0f;
            uz = 0.0f;
        }
        float vx = dy * uz - dz * uy;
        float vy = dz * ux - dx * uz;
        float vz = dx * uy - dy * ux;
        float vlen = (float)Math.sqrt(vx * vx + vy * vy + vz * vz);
        ux = dy * (vz /= vlen) - dz * (vy /= vlen);
        uy = dz * (vx /= vlen) - dx * vz;
        uz = dx * vy - dy * vx;
        int sides = 8;
        for (int i = 0; i < sides; ++i) {
            float angle1 = (float)((double)(i * 2) * Math.PI / (double)sides);
            float angle2 = (float)((double)((i + 1) * 2) * Math.PI / (double)sides);
            float cos1 = (float)Math.cos(angle1);
            float sin1 = (float)Math.sin(angle1);
            float cos2 = (float)Math.cos(angle2);
            float sin2 = (float)Math.sin(angle2);
            float r1x = radius * (cos1 * ux + sin1 * vx);
            float r1y = radius * (cos1 * uy + sin1 * vy);
            float r1z = radius * (cos1 * uz + sin1 * vz);
            float r2x = radius * (cos2 * ux + sin2 * vx);
            float r2y = radius * (cos2 * uy + sin2 * vy);
            float r2z = radius * (cos2 * uz + sin2 * vz);
            buffer.addVertex(matrix, x1 + r1x, y1 + r1y, z1 + r1z).setColor(red, green, blue, alpha);
            buffer.addVertex(matrix, x1 + r2x, y1 + r2y, z1 + r2z).setColor(red, green, blue, alpha);
            buffer.addVertex(matrix, x2 + r2x, y2 + r2y, z2 + r2z).setColor(red, green, blue, alpha);
            buffer.addVertex(matrix, x2 + r1x, y2 + r1y, z2 + r1z).setColor(red, green, blue, alpha);
        }
    }

    private void renderGlowSegment(Matrix4f matrix, VertexConsumer buffer, float x1, float y1, float z1, float x2, float y2, float z2, float thickness, float opacity) {
        float red = 0.5f;
        float green = 0.5f;
        float blue = 0.9f;
        for (int layer = 0; layer < 3; ++layer) {
            float layerThickness = thickness * (1.5f + (float)layer * 0.5f);
            float layerAlpha = opacity * 0.3f * (1.0f - (float)layer * 0.3f);
            this.renderCylindricalSegment(matrix, buffer, x1, y1, z1, x2, y2, z2, red, green, blue, layerAlpha, layerThickness);
        }
    }

    private void renderLightningSegment(Matrix4f matrix, VertexConsumer buffer, float x1, float y1, float z1, float x2, float y2, float z2, int segmentIndex, float thickness, int layer, float opacity) {
        float red = 0.45f;
        float green = 0.45f;
        float blue = 0.5f;
        float alpha = 0.3f * (1.0f - (float)layer * 0.2f) * opacity;
        CustomLightningBoltRenderer.quad(matrix, buffer, x1, y1, z1, x2, y2, z2, red, green, blue, alpha, thickness, false, false, true, false);
        CustomLightningBoltRenderer.quad(matrix, buffer, x1, y1, z1, x2, y2, z2, red, green, blue, alpha, thickness, true, false, true, true);
        CustomLightningBoltRenderer.quad(matrix, buffer, x1, y1, z1, x2, y2, z2, red, green, blue, alpha, thickness, true, true, false, true);
        CustomLightningBoltRenderer.quad(matrix, buffer, x1, y1, z1, x2, y2, z2, red, green, blue, alpha, thickness, false, true, false, false);
    }

    private void renderBranches(Matrix4f matrix, VertexConsumer buffer, List<Vec3> path, RandomSource random, float opacity) {
        int branchCount = 2 + random.nextInt(3);
        for (int i = 0; i < branchCount; ++i) {
            if (path.size() < 3) continue;
            int startIndex = random.nextInt(path.size() - 2);
            Vec3 branchStart = path.get(startIndex);
            float branchLength = 1.0f + random.nextFloat() * 2.0f;
            float angleH = random.nextFloat() * (float)Math.PI * 2.0f;
            float angleV = -0.5f - random.nextFloat() * 0.5f;
            Vec3 branchEnd = branchStart.add(Math.cos(angleH) * Math.cos(angleV) * (double)branchLength, Math.sin(angleV) * (double)branchLength, Math.sin(angleH) * Math.cos(angleV) * (double)branchLength);
            this.renderLightningSegment(matrix, buffer, (float)branchStart.x, (float)branchStart.y, (float)branchStart.z, (float)branchEnd.x, (float)branchEnd.y, (float)branchEnd.z, 0, 0.05f, 0, opacity);
        }
    }

    private static void quad(Matrix4f pose, VertexConsumer buffer, float x1, float y1, float z1, float x2, float y2, float z2, float red, float green, float blue, float alpha, float thickness, boolean addX1, boolean addZ1, boolean addX2, boolean addZ2) {
        buffer.addVertex(pose, x1 + (addX1 ? thickness : -thickness), y1, z1 + (addZ1 ? thickness : -thickness)).setColor(red, green, blue, alpha);
        buffer.addVertex(pose, x2 + (addX1 ? thickness : -thickness), y2, z2 + (addZ1 ? thickness : -thickness)).setColor(red, green, blue, alpha);
        buffer.addVertex(pose, x2 + (addX2 ? thickness : -thickness), y2, z2 + (addZ2 ? thickness : -thickness)).setColor(red, green, blue, alpha);
        buffer.addVertex(pose, x1 + (addX2 ? thickness : -thickness), y1, z1 + (addZ2 ? thickness : -thickness)).setColor(red, green, blue, alpha);
    }

    public CustomLightningBoltRenderState createRenderState() {
        return new CustomLightningBoltRenderState();
    }

    public void extractRenderState(CustomLightningBoltEntity entity, CustomLightningBoltRenderState renderState, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)renderState, partialTick);
        renderState.seed = entity.getId();
        renderState.hasStruck = entity.hasStruck();
        renderState.pathPoints = entity.getRenderPathPoints();
        renderState.lifetime = entity.tickCount;
        renderState.progress = (float)entity.tickCount + partialTick;
        if (renderState.hasStruck) {
            int strikeTime = entity.tickCount - 10;
            renderState.strikeProgress = Math.max(0, Math.min(20, strikeTime));
        } else {
            renderState.strikeProgress = 0.0f;
        }
    }

    protected boolean affectedByCulling(CustomLightningBoltEntity entity) {
        return false;
    }

    public boolean shouldRender(CustomLightningBoltEntity entity, Frustum frustum, double x, double y, double z) {
        return true;
    }
}

