/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.entity.renderer;

import com.mafuyu33.mafishcrossbow.entity.custom.CustomShulkerBulletEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.ShulkerBulletModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.ShulkerBulletRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionfc;

public class CustomShulkerBulletRenderer
extends EntityRenderer<CustomShulkerBulletEntity, ShulkerBulletRenderState> {
    private static final ResourceLocation TEXTURE_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/entity/shulker/spark.png");
    private static final RenderType RENDER_TYPE = RenderType.entityTranslucent((ResourceLocation)TEXTURE_LOCATION);
    private final ShulkerBulletModel model;

    public CustomShulkerBulletRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new ShulkerBulletModel(context.bakeLayer(ModelLayers.SHULKER_BULLET));
    }

    protected int getBlockLightLevel(CustomShulkerBulletEntity entity, BlockPos pos) {
        return 15;
    }

    public void render(ShulkerBulletRenderState renderState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        poseStack.pushPose();
        float age = renderState.ageInTicks;
        poseStack.translate(0.0f, 0.15f, 0.0f);
        poseStack.mulPose((Quaternionfc)Axis.YP.rotationDegrees(Mth.sin((float)(age * 0.1f)) * 180.0f));
        poseStack.mulPose((Quaternionfc)Axis.XP.rotationDegrees(Mth.cos((float)(age * 0.1f)) * 180.0f));
        poseStack.mulPose((Quaternionfc)Axis.ZP.rotationDegrees(Mth.sin((float)(age * 0.15f)) * 360.0f));
        poseStack.scale(-0.5f, -0.5f, 0.5f);
        this.model.setupAnim(renderState);
        VertexConsumer vertexConsumer = bufferSource.getBuffer(this.model.renderType(TEXTURE_LOCATION));
        this.model.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.scale(1.5f, 1.5f, 1.5f);
        VertexConsumer vertexConsumerGlow = bufferSource.getBuffer(RENDER_TYPE);
        this.model.renderToBuffer(poseStack, vertexConsumerGlow, packedLight, OverlayTexture.NO_OVERLAY, 0x26FFFFFF);
        poseStack.popPose();
        super.render((EntityRenderState)renderState, poseStack, bufferSource, packedLight);
    }

    public ShulkerBulletRenderState createRenderState() {
        return new ShulkerBulletRenderState();
    }

    public void extractRenderState(CustomShulkerBulletEntity entity, ShulkerBulletRenderState renderState, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)renderState, partialTick);
        renderState.yRot = entity.getYRot(partialTick);
        renderState.xRot = entity.getXRot(partialTick);
    }
}

