/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.gui;

import com.mafuyu33.mafishcrossbow.block.entity.CrossbowPresetWorkbenchBlockEntity;
import com.mafuyu33.mafishcrossbow.gui.ModMenuTypes;
import com.mafuyu33.mafishcrossbow.rougecraft.preset.CrossbowPresetSavedData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ChargedProjectiles;
import org.jetbrains.annotations.Nullable;

public class CrossbowPresetWorkbenchMenu
extends AbstractContainerMenu {
    private final Container workbenchContainer;
    private final CrossbowPresetWorkbenchBlockEntity blockEntity;
    private final BlockPos blockPos;
    private final Inventory playerInventory;

    public CrossbowPresetWorkbenchMenu(int containerId, Inventory playerInventory, ClientData clientData) {
        this(containerId, playerInventory, (Container)new SimpleContainer(2), null, clientData.blockPos());
    }

    public CrossbowPresetWorkbenchMenu(int containerId, Inventory playerInventory, CrossbowPresetWorkbenchBlockEntity blockEntity) {
        this(containerId, playerInventory, (Container)blockEntity, blockEntity, blockEntity.getBlockPos());
    }

    private CrossbowPresetWorkbenchMenu(int containerId, Inventory playerInventory, Container container, @Nullable CrossbowPresetWorkbenchBlockEntity blockEntity, BlockPos blockPos) {
        super((MenuType)ModMenuTypes.CROSSBOW_PRESET_WORKBENCH.get(), containerId);
        this.workbenchContainer = container;
        this.blockEntity = blockEntity;
        this.blockPos = blockPos;
        this.playerInventory = playerInventory;
        CrossbowPresetWorkbenchMenu.checkContainerSize((Container)container, (int)2);
        container.startOpen(playerInventory.player);
        final CrossbowPresetWorkbenchMenu menuRef = this;
        this.addSlot(new Slot(this, container, 0, 15, 47){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }
        });
        this.addSlot(new Slot(this, container, 1, 35, 47){

            public boolean mayPlace(ItemStack stack) {
                return stack.getItem() == Items.CROSSBOW;
            }

            public int getMaxStackSize() {
                return 1;
            }

            public void setByPlayer(ItemStack newStack, ItemStack oldStack) {
                if (!newStack.isEmpty()) {
                    menuRef.moveOutputSlotToPlayer();
                }
                super.setByPlayer(newStack, oldStack);
            }
        });
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, 8 + col * 18, 142));
        }
    }

    public void moveOutputSlotToPlayer() {
        ItemStack outputStack = this.workbenchContainer.getItem(0);
        if (!outputStack.isEmpty()) {
            if (!this.playerInventory.add(outputStack.copy())) {
                this.playerInventory.player.drop(outputStack.copy(), false);
            }
            this.workbenchContainer.setItem(0, ItemStack.EMPTY);
        }
    }

    public void moveInputSlotToPlayer() {
        ItemStack inputStack = this.workbenchContainer.getItem(1);
        if (!inputStack.isEmpty()) {
            if (!this.playerInventory.add(inputStack.copy())) {
                this.playerInventory.player.drop(inputStack.copy(), false);
            }
            this.workbenchContainer.setItem(1, ItemStack.EMPTY);
        }
    }

    public List<ItemStack> getInputItemContents() {
        ArrayList<ItemStack> contents = new ArrayList<ItemStack>();
        ItemStack input = this.workbenchContainer.getItem(1);
        if (input.isEmpty() || input.getItem() != Items.CROSSBOW) {
            return contents;
        }
        ChargedProjectiles charged = (ChargedProjectiles)input.get(DataComponents.CHARGED_PROJECTILES);
        if (charged != null && !charged.isEmpty()) {
            contents.addAll(charged.getItems());
        }
        return contents;
    }

    public List<ItemStack> getOutputItemContents() {
        ArrayList<ItemStack> contents = new ArrayList<ItemStack>();
        ItemStack output = this.workbenchContainer.getItem(0);
        if (output.isEmpty() || output.getItem() != Items.CROSSBOW) {
            return contents;
        }
        ChargedProjectiles charged = (ChargedProjectiles)output.get(DataComponents.CHARGED_PROJECTILES);
        if (charged != null && !charged.isEmpty()) {
            contents.addAll(charged.getItems());
        }
        return contents;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 2) {
                if (!this.moveItemStackTo(itemstack1, 2, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else if (itemstack1.getItem() == Items.CROSSBOW) {
                this.moveOutputSlotToPlayer();
                if (!this.moveItemStackTo(itemstack1, 1, 2, false)) {
                    return ItemStack.EMPTY;
                }
            } else {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        return this.workbenchContainer.stillValid(player);
    }

    public void removed(Player player) {
        super.removed(player);
        this.workbenchContainer.stopOpen(player);
    }

    public String encode() {
        if (this.blockEntity != null) {
            return this.blockEntity.encodeInputCrossbow();
        }
        return null;
    }

    public boolean decode(String encodedString) {
        if (this.blockEntity != null) {
            return this.blockEntity.decodeToOutputSlot(encodedString);
        }
        return false;
    }

    public boolean savePreset(String name, boolean addToLootPool) {
        if (this.blockEntity != null) {
            return this.blockEntity.savePreset(name, addToLootPool);
        }
        return false;
    }

    public boolean loadPreset(String name) {
        if (this.blockEntity != null) {
            return this.blockEntity.loadPreset(name);
        }
        return false;
    }

    public boolean deletePreset(String name) {
        if (this.blockEntity != null) {
            return this.blockEntity.deletePreset(name);
        }
        return false;
    }

    public List<CrossbowPresetSavedData.PresetEntry> getAllPresets() {
        if (this.blockEntity != null) {
            return this.blockEntity.getAllPresets();
        }
        return new ArrayList<CrossbowPresetSavedData.PresetEntry>();
    }

    public boolean setPresetLootPoolStatus(String name, boolean addToLootPool) {
        if (this.blockEntity != null) {
            return this.blockEntity.setPresetLootPoolStatus(name, addToLootPool);
        }
        return false;
    }

    public String getCurrentEncodedString() {
        if (this.blockEntity != null) {
            return this.blockEntity.getCurrentEncodedString();
        }
        return "";
    }

    public String getCurrentPresetName() {
        if (this.blockEntity != null) {
            return this.blockEntity.getCurrentPresetName();
        }
        return "";
    }

    public boolean isAddToLootPool() {
        if (this.blockEntity != null) {
            return this.blockEntity.isAddToLootPool();
        }
        return false;
    }

    @Nullable
    public CrossbowPresetWorkbenchBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public record ClientData(BlockPos blockPos) {
    }
}

