/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.gui;

import cn.ussshenzhou.t88.gui.widegt.TButton;
import cn.ussshenzhou.t88.gui.widegt.TLabel;
import cn.ussshenzhou.t88.gui.widegt.TSelectList;
import com.mafuyu33.mafishcrossbow.gui.CrossbowPresetWorkbenchMenu;
import com.mafuyu33.mafishcrossbow.network.packet.C2S.PresetWorkbenchActionC2SPacket;
import com.mafuyu33.mafishcrossbow.network.packet.S2C.PresetListSyncS2CPacket;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class CrossbowPresetWorkbenchScreen
extends AbstractContainerScreen<CrossbowPresetWorkbenchMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/enchanting_table.png");
    private TLabel presetListLabel;
    private TSelectList<PresetEntry> presetList;
    private TButton getButton;
    private TButton deleteButton;
    private TLabel encodedStringLabel;
    private EditBox encodedStringBox;
    private EditBox presetNameBox;
    private TButton encodeButton;
    private TButton decodeButton;
    private TButton saveButton;
    private TButton copyButton;
    private TButton lootPoolToggle;
    private TLabel contentsLabel;
    private TLabel titleLabel;
    private TLabel outputSlotLabel;
    private TLabel inputSlotLabel;
    private TLabel statusLabel;
    private boolean addToLootPool = false;
    private String statusMessage = "";
    private int statusColor = 0xFFFFFF;
    private long statusExpireTime = 0L;

    public CrossbowPresetWorkbenchScreen(CrossbowPresetWorkbenchMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageWidth = 176;
        this.imageHeight = 166;
        this.inventoryLabelY = this.imageHeight - 94;
        this.presetListLabel = new TLabel((Component)Component.translatable((String)"gui.mafishcrossbow.preset_list"));
        this.presetList = new TSelectList(12, 0);
        this.presetList.setBackground(Integer.MIN_VALUE);
        this.getButton = new TButton((Component)Component.translatable((String)"gui.mafishcrossbow.get"));
        this.getButton.setOnPress(btn -> this.onGet());
        this.deleteButton = new TButton((Component)Component.translatable((String)"gui.mafishcrossbow.delete"));
        this.deleteButton.setOnPress(btn -> this.onDelete());
        this.encodedStringLabel = new TLabel((Component)Component.translatable((String)"gui.mafishcrossbow.encoded_string"));
        this.encodeButton = new TButton((Component)Component.translatable((String)"gui.mafishcrossbow.encode"));
        this.encodeButton.setOnPress(btn -> this.onEncode());
        this.decodeButton = new TButton((Component)Component.translatable((String)"gui.mafishcrossbow.decode"));
        this.decodeButton.setOnPress(btn -> this.onDecode());
        this.saveButton = new TButton((Component)Component.translatable((String)"gui.mafishcrossbow.save"));
        this.saveButton.setOnPress(btn -> this.onSave());
        this.copyButton = new TButton((Component)Component.translatable((String)"gui.mafishcrossbow.copy"));
        this.copyButton.setOnPress(btn -> this.onCopy());
        this.lootPoolToggle = new TButton((Component)Component.translatable((String)"gui.mafishcrossbow.loot_pool.off"));
        this.lootPoolToggle.setOnPress(btn -> this.onToggleLootPool());
        this.contentsLabel = new TLabel((Component)Component.translatable((String)"gui.mafishcrossbow.contents"));
        this.titleLabel = new TLabel(title);
        this.outputSlotLabel = new TLabel((Component)Component.translatable((String)"gui.mafishcrossbow.slot.output"));
        this.inputSlotLabel = new TLabel((Component)Component.translatable((String)"gui.mafishcrossbow.slot.input"));
        this.statusLabel = new TLabel((Component)Component.empty());
    }

    protected void init() {
        super.init();
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        int relX = this.leftPos;
        int relY = this.topPos;
        this.presetListLabel.setFontSize(7.0f);
        this.presetListLabel.setAbsBounds(relX - 95, relY + 10, 90, 12);
        this.presetList.setAbsBounds(relX - 95, relY + 24, 90, 100);
        this.getButton.setAbsBounds(relX - 95, relY + 126, 43, 14);
        this.deleteButton.setAbsBounds(relX - 50, relY + 126, 43, 14);
        this.encodedStringLabel.setFontSize(7.0f);
        this.encodedStringLabel.setAbsBounds(relX + 181, relY + 10, 90, 12);
        this.encodedStringBox = new EditBox(this.font, relX + 181, relY + 24, 90, 36, (Component)Component.translatable((String)"gui.mafishcrossbow.encoded_string"));
        this.encodedStringBox.setMaxLength(500);
        this.encodedStringBox.setValue("");
        this.encodedStringBox.setHint((Component)Component.translatable((String)"gui.mafishcrossbow.encoded_string.hint"));
        this.addRenderableWidget((GuiEventListener)this.encodedStringBox);
        this.presetNameBox = new EditBox(this.font, relX + 181, relY + 64, 90, 12, (Component)Component.translatable((String)"gui.mafishcrossbow.preset_name"));
        this.presetNameBox.setMaxLength(32);
        this.presetNameBox.setValue("");
        this.presetNameBox.setHint((Component)Component.translatable((String)"gui.mafishcrossbow.preset_name.hint"));
        this.addRenderableWidget((GuiEventListener)this.presetNameBox);
        this.encodeButton.setAbsBounds(relX + 181, relY + 80, 43, 14);
        this.decodeButton.setAbsBounds(relX + 226, relY + 80, 43, 14);
        this.saveButton.setAbsBounds(relX + 181, relY + 96, 43, 14);
        this.copyButton.setAbsBounds(relX + 226, relY + 96, 43, 14);
        this.lootPoolToggle.setAbsBounds(relX + 181, relY + 112, 88, 14);
        this.contentsLabel.setFontSize(7.0f);
        this.contentsLabel.setAbsBounds(relX + 60, relY + 14, 108, 12);
        this.titleLabel.setAbsBounds(relX + this.titleLabelX, relY + 6, 80, 10);
        this.outputSlotLabel.setAbsBounds(relX + 15, relY + 37, 16, 10);
        this.inputSlotLabel.setAbsBounds(relX + 35, relY + 37, 16, 10);
        this.statusLabel.setAbsBounds(relX + 20, relY + 72, 136, 10);
        this.presetListLabel.setParentScreen(null);
        this.presetList.setParentScreen(null);
        this.getButton.setParentScreen(null);
        this.deleteButton.setParentScreen(null);
        this.encodedStringLabel.setParentScreen(null);
        this.encodeButton.setParentScreen(null);
        this.decodeButton.setParentScreen(null);
        this.saveButton.setParentScreen(null);
        this.copyButton.setParentScreen(null);
        this.lootPoolToggle.setParentScreen(null);
        this.contentsLabel.setParentScreen(null);
        this.titleLabel.setParentScreen(null);
        this.outputSlotLabel.setParentScreen(null);
        this.inputSlotLabel.setParentScreen(null);
        this.statusLabel.setParentScreen(null);
        this.requestPresetListSync();
    }

    private void requestPresetListSync() {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new PresetWorkbenchActionC2SPacket(PresetWorkbenchActionC2SPacket.Action.REQUEST_SYNC, ((CrossbowPresetWorkbenchMenu)this.menu).getBlockPos(), "", "", false), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void onEncode() {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new PresetWorkbenchActionC2SPacket(PresetWorkbenchActionC2SPacket.Action.ENCODE, ((CrossbowPresetWorkbenchMenu)this.menu).getBlockPos(), "", "", false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.setStatus(Component.translatable((String)"gui.mafishcrossbow.encoding").getString(), 0xFFFF00);
    }

    private void onDecode() {
        String encoded = this.encodedStringBox.getValue();
        if (encoded.isEmpty()) {
            this.setStatus(Component.translatable((String)"gui.mafishcrossbow.no_encoded_string").getString(), 0xFF0000);
            return;
        }
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new PresetWorkbenchActionC2SPacket(PresetWorkbenchActionC2SPacket.Action.DECODE, ((CrossbowPresetWorkbenchMenu)this.menu).getBlockPos(), encoded, "", false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.setStatus(Component.translatable((String)"gui.mafishcrossbow.decoding").getString(), 0xFFFF00);
    }

    private void onSave() {
        String name = this.presetNameBox.getValue();
        if (name.isEmpty()) {
            this.setStatus(Component.translatable((String)"gui.mafishcrossbow.no_preset_name").getString(), 0xFF0000);
            return;
        }
        String encoded = this.encodedStringBox.getValue();
        if (encoded.isEmpty()) {
            this.setStatus(Component.translatable((String)"gui.mafishcrossbow.no_encoded_string").getString(), 0xFF0000);
            return;
        }
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new PresetWorkbenchActionC2SPacket(PresetWorkbenchActionC2SPacket.Action.SAVE, ((CrossbowPresetWorkbenchMenu)this.menu).getBlockPos(), encoded, name, this.addToLootPool), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.setStatus(Component.translatable((String)"gui.mafishcrossbow.saving").getString(), 0xFFFF00);
    }

    private void onGet() {
        TSelectList.Entry selected = (TSelectList.Entry)this.presetList.getSelected();
        if (selected == null) {
            this.setStatus(Component.translatable((String)"gui.mafishcrossbow.no_preset_selected").getString(), 0xFF0000);
            return;
        }
        PresetEntry entry = (PresetEntry)selected.getContent();
        String name = entry.name();
        PresetWorkbenchActionC2SPacket.Action action = entry.isBuiltIn() ? PresetWorkbenchActionC2SPacket.Action.LOAD_BUILTIN : PresetWorkbenchActionC2SPacket.Action.LOAD;
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new PresetWorkbenchActionC2SPacket(action, ((CrossbowPresetWorkbenchMenu)this.menu).getBlockPos(), "", name, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.setStatus(Component.translatable((String)"gui.mafishcrossbow.getting").getString(), 0xFFFF00);
    }

    private void onDelete() {
        TSelectList.Entry selected = (TSelectList.Entry)this.presetList.getSelected();
        if (selected == null) {
            this.setStatus(Component.translatable((String)"gui.mafishcrossbow.no_preset_selected").getString(), 0xFF0000);
            return;
        }
        PresetEntry entry = (PresetEntry)selected.getContent();
        if (entry.isBuiltIn()) {
            this.setStatus(Component.translatable((String)"gui.mafishcrossbow.cannot_delete_builtin").getString(), 0xFF0000);
            return;
        }
        String name = entry.name();
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new PresetWorkbenchActionC2SPacket(PresetWorkbenchActionC2SPacket.Action.DELETE, ((CrossbowPresetWorkbenchMenu)this.menu).getBlockPos(), "", name, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.setStatus(Component.translatable((String)"gui.mafishcrossbow.deleting").getString(), 0xFFFF00);
    }

    private void onCopy() {
        String encoded = this.encodedStringBox.getValue();
        if (!encoded.isEmpty()) {
            Minecraft.getInstance().keyboardHandler.setClipboard(encoded);
            this.setStatus(Component.translatable((String)"gui.mafishcrossbow.copied").getString(), 65280);
        }
    }

    private void onToggleLootPool() {
        this.addToLootPool = !this.addToLootPool;
        this.lootPoolToggle.setMessage((Component)(this.addToLootPool ? Component.translatable((String)"gui.mafishcrossbow.loot_pool.on") : Component.translatable((String)"gui.mafishcrossbow.loot_pool.off")));
    }

    private void setStatus(String message, int color) {
        this.statusMessage = message;
        this.statusColor = color;
        this.statusExpireTime = System.currentTimeMillis() + 3000L;
    }

    public void updateEncodedString(String encoded) {
        if (this.encodedStringBox != null) {
            this.encodedStringBox.setValue(encoded);
        }
    }

    public void updatePresetName(String name) {
        if (this.presetNameBox != null) {
            this.presetNameBox.setValue(name);
        }
    }

    public void setOperationResult(boolean success, String message) {
        this.setStatus(message, success ? 65280 : 0xFF0000);
    }

    public void updatePresetList(List<PresetListSyncS2CPacket.PresetInfo> presets) {
        this.presetList.clearElement();
        for (PresetListSyncS2CPacket.PresetInfo preset : presets) {
            String display = preset.isBuiltIn() ? (preset.isDynamic() ? "\u00a75" + preset.name() : "\u00a76" + preset.name()) : preset.name() + (preset.addToLootPool() ? " \u00a7a[L]" : "");
            this.presetList.addElement(new PresetEntry(preset.name(), preset.addToLootPool(), preset.isBuiltIn(), preset.isDynamic(), display));
        }
    }

    public void containerTick() {
        super.containerTick();
        this.presetListLabel.layout();
        this.presetList.layout();
        this.getButton.layout();
        this.deleteButton.layout();
        this.encodedStringLabel.layout();
        this.encodeButton.layout();
        this.decodeButton.layout();
        this.saveButton.layout();
        this.copyButton.layout();
        this.lootPoolToggle.layout();
        this.contentsLabel.layout();
        this.titleLabel.layout();
        this.outputSlotLabel.layout();
        this.inputSlotLabel.layout();
        this.statusLabel.layout();
        this.presetList.tickT();
        if (!this.statusMessage.isEmpty() && System.currentTimeMillis() < this.statusExpireTime) {
            this.statusLabel.setText((Component)Component.literal((String)this.statusMessage));
        } else {
            this.statusLabel.setText((Component)Component.empty());
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.presetListLabel.render(guiGraphics, mouseX, mouseY, partialTick);
        this.presetList.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        this.getButton.render(guiGraphics, mouseX, mouseY, partialTick);
        this.deleteButton.render(guiGraphics, mouseX, mouseY, partialTick);
        this.encodedStringLabel.render(guiGraphics, mouseX, mouseY, partialTick);
        this.encodeButton.render(guiGraphics, mouseX, mouseY, partialTick);
        this.decodeButton.render(guiGraphics, mouseX, mouseY, partialTick);
        this.saveButton.render(guiGraphics, mouseX, mouseY, partialTick);
        this.copyButton.render(guiGraphics, mouseX, mouseY, partialTick);
        this.lootPoolToggle.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderContentsInfo(guiGraphics, mouseX, mouseY);
        this.titleLabel.render(guiGraphics, mouseX, mouseY, partialTick);
        this.outputSlotLabel.render(guiGraphics, mouseX, mouseY, partialTick);
        this.inputSlotLabel.render(guiGraphics, mouseX, mouseY, partialTick);
        this.statusLabel.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderContentsInfo(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int baseX = this.leftPos + 55;
        int baseY = this.topPos + 10;
        guiGraphics.fill(baseX, baseY, baseX + 115, baseY + 65, -3750202);
        this.contentsLabel.render(guiGraphics, mouseX, mouseY, 0.0f);
        List<ItemStack> contents = ((CrossbowPresetWorkbenchMenu)this.menu).getInputItemContents();
        if (contents.isEmpty()) {
            MutableComponent emptyHint = Component.translatable((String)"gui.mafishcrossbow.contents.empty");
            int textX = baseX + (108 - this.font.width((FormattedText)emptyHint)) / 2;
            guiGraphics.drawString(this.font, (Component)emptyHint, textX, baseY + 24, 0x808080, false);
        } else {
            int itemY = baseY + 14;
            int maxItems = Math.min(contents.size(), 3);
            for (int i = 0; i < maxItems; ++i) {
                ItemStack item = contents.get(i);
                guiGraphics.renderItem(item, baseX + 2, itemY);
                Object name = item.getHoverName().getString();
                if (this.font.width((String)name) > 85) {
                    name = this.font.plainSubstrByWidth((String)name, 82) + "...";
                }
                guiGraphics.drawString(this.font, (String)name, baseX + 20, itemY + 4, 0xFFFFFF, false);
                itemY += 12;
            }
            if (contents.size() > 3) {
                MutableComponent moreText = Component.translatable((String)"gui.mafishcrossbow.contents.more", (Object[])new Object[]{contents.size() - 3});
                guiGraphics.drawString(this.font, (Component)moreText, baseX + 2, itemY + 2, 0xAAAAAA, false);
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.presetList.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.getButton.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.deleteButton.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.encodeButton.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.decodeButton.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.saveButton.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.copyButton.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.lootPoolToggle.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.presetList.mouseScrolled(mouseX, mouseY, deltaX, deltaY)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.encodedStringBox.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.presetNameBox.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (this.encodedStringBox.charTyped(codePoint, modifiers)) {
            return true;
        }
        if (this.presetNameBox.charTyped(codePoint, modifiers)) {
            return true;
        }
        return super.charTyped(codePoint, modifiers);
    }

    public record PresetEntry(String name, boolean inLootPool, boolean isBuiltIn, boolean isDynamic, String displayName) {
        @Override
        public String toString() {
            return this.displayName;
        }
    }
}

