/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.gui;

import com.mafuyu33.mafishcrossbow.block.entity.CrossbowTurretBlockEntity;
import com.mafuyu33.mafishcrossbow.gui.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CrossbowTurretMenu
extends AbstractContainerMenu {
    private final Container turretContainer;
    private final ContainerData turretData;
    private final CrossbowTurretBlockEntity blockEntity;
    private final BlockPos blockPos;

    public CrossbowTurretMenu(int containerId, Inventory playerInventory, ClientData clientData) {
        this(containerId, playerInventory, (Container)new SimpleContainer(9), (ContainerData)new SimpleContainerData(5), null, clientData.blockPos());
    }

    public CrossbowTurretMenu(int containerId, Inventory playerInventory, CrossbowTurretBlockEntity blockEntity) {
        this(containerId, playerInventory, (Container)blockEntity, (ContainerData)new SimpleContainerData(5), blockEntity, blockEntity.getBlockPos());
    }

    private CrossbowTurretMenu(int containerId, Inventory playerInventory, Container turretContainer, ContainerData turretData, CrossbowTurretBlockEntity blockEntity, BlockPos blockPos) {
        super((MenuType)ModMenuTypes.CROSSBOW_TURRET.get(), containerId);
        int col;
        int row;
        this.turretContainer = turretContainer;
        this.turretData = turretData;
        this.blockEntity = blockEntity;
        this.blockPos = blockPos;
        CrossbowTurretMenu.checkContainerSize((Container)turretContainer, (int)9);
        turretContainer.startOpen(playerInventory.player);
        this.addDataSlots(turretData);
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 3; ++col) {
                this.addSlot(new Slot(turretContainer, col + row * 3, 62 + col * 18, 17 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col2 = 0; col2 < 9; ++col2) {
            this.addSlot(new Slot((Container)playerInventory, col2, 8 + col2 * 18, 142));
        }
        if (blockEntity != null) {
            int mode = blockEntity.getMode();
            float yaw = blockEntity.getFixedYaw();
            float pitch = blockEntity.getFixedPitch();
            boolean enabled = blockEntity.isEnabled();
            int targetType = blockEntity.getTargetType();
            System.out.println("[TurretMenu] Constructor: mode=" + mode + ", yaw=" + yaw + ", pitch=" + pitch + ", enabled=" + enabled + ", targetType=" + targetType);
            turretData.set(0, mode);
            turretData.set(1, Float.floatToIntBits(yaw));
            turretData.set(2, Float.floatToIntBits(pitch));
            turretData.set(3, enabled ? 1 : 0);
            turretData.set(4, targetType);
        } else {
            System.out.println("[TurretMenu] Constructor: blockEntity is NULL (client side)");
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 9 ? !this.moveItemStackTo(itemstack1, 9, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 0, 9, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        if (this.blockEntity != null) {
            int enabledInt;
            int mode = this.blockEntity.getMode();
            float yaw = this.blockEntity.getFixedYaw();
            float pitch = this.blockEntity.getFixedPitch();
            boolean enabled = this.blockEntity.isEnabled();
            int targetType = this.blockEntity.getTargetType();
            int n = enabledInt = enabled ? 1 : 0;
            if (this.turretData.get(0) != mode || Float.floatToIntBits(yaw) != this.turretData.get(1) || Float.floatToIntBits(pitch) != this.turretData.get(2) || this.turretData.get(3) != enabledInt || this.turretData.get(4) != targetType) {
                System.out.println("[TurretMenu] broadcastChanges: mode=" + mode + ", yaw=" + yaw + ", pitch=" + pitch + ", enabled=" + enabled + ", targetType=" + targetType);
            }
            this.turretData.set(0, mode);
            this.turretData.set(1, Float.floatToIntBits(yaw));
            this.turretData.set(2, Float.floatToIntBits(pitch));
            this.turretData.set(3, enabledInt);
            this.turretData.set(4, targetType);
        }
    }

    public boolean stillValid(Player player) {
        return this.turretContainer.stillValid(player);
    }

    public void removed(Player player) {
        super.removed(player);
        this.turretContainer.stopOpen(player);
    }

    public int getMode() {
        return this.turretData.get(0);
    }

    public float getFixedYaw() {
        return Float.intBitsToFloat(this.turretData.get(1));
    }

    public float getFixedPitch() {
        return Float.intBitsToFloat(this.turretData.get(2));
    }

    public boolean getEnabled() {
        return this.turretData.get(3) != 0;
    }

    public int getTargetType() {
        return this.turretData.get(4);
    }

    public CrossbowTurretBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public void setMode(int mode) {
        if (this.blockEntity != null) {
            this.blockEntity.setMode(mode);
            this.turretData.set(0, mode);
        }
    }

    public void setFixedYaw(float yaw) {
        if (this.blockEntity != null) {
            this.blockEntity.setFixedYaw(yaw);
            this.turretData.set(1, Float.floatToIntBits(yaw));
        }
    }

    public void setFixedPitch(float pitch) {
        if (this.blockEntity != null) {
            this.blockEntity.setFixedPitch(pitch);
            this.turretData.set(2, Float.floatToIntBits(pitch));
        }
    }

    public void setEnabled(boolean enabled) {
        if (this.blockEntity != null) {
            this.blockEntity.setEnabled(enabled);
            this.turretData.set(3, enabled ? 1 : 0);
        }
    }

    public void setTargetType(int targetType) {
        if (this.blockEntity != null) {
            this.blockEntity.setTargetType(targetType);
            this.turretData.set(4, targetType);
        }
    }

    public record ClientData(BlockPos blockPos) {
    }
}

