/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.gui;

import cn.ussshenzhou.t88.gui.container.TVerticalScrollContainer;
import cn.ussshenzhou.t88.gui.util.Border;
import cn.ussshenzhou.t88.gui.widegt.TButton;
import cn.ussshenzhou.t88.gui.widegt.TLabel;
import cn.ussshenzhou.t88.gui.widegt.TPanel;
import cn.ussshenzhou.t88.gui.widegt.TSlider;
import cn.ussshenzhou.t88.gui.widegt.TWidget;
import com.mafuyu33.mafishcrossbow.block.entity.CrossbowTurretBlockEntity;
import com.mafuyu33.mafishcrossbow.client.TurretManualAimingHandler;
import com.mafuyu33.mafishcrossbow.gui.CrossbowTurretMenu;
import com.mafuyu33.mafishcrossbow.gui.render.GuiGraphicsHelper;
import com.mafuyu33.mafishcrossbow.gui.render.RenderDebugConfig;
import com.mafuyu33.mafishcrossbow.network.packet.C2S.TurretConfigC2SPacket;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class CrossbowTurretScreen
extends AbstractContainerScreen<CrossbowTurretMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.withDefaultNamespace((String)"textures/gui/container/dispenser.png");
    private TButton modeButton;
    private TButton enabledButton;
    private TButton targetTypeButton;
    private TButton manualAimButton;
    private TPanel fixedDirectionPanel;
    private TLabel yawLabel;
    private TSlider yawSlider;
    private TLabel pitchLabel;
    private TSlider pitchSlider;
    private TLabel enchantmentTitleLabel;
    private TVerticalScrollContainer enchantmentScrollContainer;
    private boolean hasEnchantments = false;
    private int currentMode = -1;
    private float currentYaw = 0.0f;
    private float currentPitch = 0.0f;
    private boolean currentEnabled = true;
    private int currentTargetType = 0;
    private int lastSyncedMode = -1;
    private float lastSyncedYaw = Float.NaN;
    private float lastSyncedPitch = Float.NaN;
    private boolean lastSyncedEnabled = true;
    private int lastSyncedTargetType = -1;
    private ItemEnchantments lastSyncedEnchantments = ItemEnchantments.EMPTY;

    public CrossbowTurretScreen(CrossbowTurretMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
        this.imageHeight = 166;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    protected void init() {
        super.init();
        int relX = this.leftPos;
        int relY = this.topPos;
        this.modeButton = new TButton(this.getModeText(this.currentMode));
        this.modeButton.setOnPress(pButton -> {
            this.currentMode = this.currentMode == 0 ? 1 : 0;
            pButton.setMessage(this.getModeText(this.currentMode));
            this.sendModeUpdate();
            this.updatePanelVisibility();
        });
        this.modeButton.setAbsBounds(relX + this.imageWidth - 50, relY + 4, 46, 16);
        this.addRenderableWidget(this.modeButton);
        this.enabledButton = new TButton(this.getEnabledText(this.currentEnabled));
        this.enabledButton.setOnPress(pButton -> {
            this.currentEnabled = !this.currentEnabled;
            pButton.setMessage(this.getEnabledText(this.currentEnabled));
            this.sendEnabledUpdate();
        });
        this.enabledButton.setAbsBounds(relX + this.imageWidth - 50, relY + 24, 46, 16);
        this.addRenderableWidget(this.enabledButton);
        this.targetTypeButton = new TButton(this.getTargetTypeText(this.currentTargetType));
        this.targetTypeButton.setOnPress(pButton -> {
            this.currentTargetType = this.currentTargetType == 0 ? 1 : 0;
            pButton.setMessage(this.getTargetTypeText(this.currentTargetType));
            this.sendTargetTypeUpdate();
        });
        this.targetTypeButton.setAbsBounds(relX + this.imageWidth - 50, relY + 44, 46, 16);
        this.manualAimButton = new TButton((Component)Component.translatable((String)"gui.mafishcrossbow.turret.manual_aim"));
        this.manualAimButton.setOnPress(pButton -> {
            TurretManualAimingHandler.startManualAiming(((CrossbowTurretMenu)this.menu).getBlockPos());
            this.onClose();
        });
        this.manualAimButton.setAbsBounds(relX + this.imageWidth - 50, relY + 44, 46, 16);
        this.fixedDirectionPanel = new TPanel();
        this.fixedDirectionPanel.setAbsBounds(relX + 8, relY + 18, 70, 50);
        this.fixedDirectionPanel.setParentScreen(null);
        this.yawLabel = new TLabel((Component)Component.translatable((String)"gui.mafishcrossbow.turret.yaw").append(" " + String.format("%.0f\u00b0", Float.valueOf(this.currentYaw))));
        this.yawLabel.setAbsBounds(relX + 8, relY + 20, 80, 8);
        this.yawLabel.setParentScreen(null);
        this.yawLabel.setVisibleT(false);
        this.yawSlider = new TSlider("", -180.0, 180.0, false, null, true);
        this.yawSlider.setAbsBounds(relX + 8, relY + 35, 50, 6);
        this.yawSlider.setAbsValueWithoutRespond(this.currentYaw);
        this.yawSlider.addResponder(value -> {
            this.currentYaw = (float)this.yawSlider.getAbsValue();
            this.yawLabel.setText((Component)Component.translatable((String)"gui.mafishcrossbow.turret.yaw").append(" " + String.format("%.0f\u00b0", Float.valueOf(this.currentYaw))));
            this.sendYawUpdate();
        });
        this.yawSlider.setVisibleT(false);
        this.pitchLabel = new TLabel((Component)Component.translatable((String)"gui.mafishcrossbow.turret.pitch").append(" " + String.format("%.0f\u00b0", Float.valueOf(this.currentPitch))));
        this.pitchLabel.setAbsBounds(relX + 8, relY + 45, 80, 8);
        this.pitchLabel.setParentScreen(null);
        this.pitchLabel.setVisibleT(false);
        this.pitchSlider = new TSlider("", 90.0, -90.0, false, null, true);
        this.pitchSlider.setAbsBounds(relX + 8, relY + 60, 50, 6);
        this.pitchSlider.setAbsValueWithoutRespond(this.currentPitch);
        this.pitchSlider.addResponder(value -> {
            this.currentPitch = (float)this.pitchSlider.getAbsValue();
            this.pitchLabel.setText((Component)Component.translatable((String)"gui.mafishcrossbow.turret.pitch").append(" " + String.format("%.0f\u00b0", Float.valueOf(this.currentPitch))));
            this.sendPitchUpdate();
        });
        this.pitchSlider.setVisibleT(false);
        int enchantmentX = relX - 69;
        int enchantmentY = relY + 82;
        int enchantmentWidth = 68;
        int enchantmentHeight = 65;
        this.enchantmentTitleLabel = new TLabel((Component)Component.translatable((String)"gui.mafishcrossbow.turret.enchantments"));
        this.enchantmentTitleLabel.setAbsBounds(enchantmentX, enchantmentY, enchantmentWidth, 10);
        this.enchantmentTitleLabel.setParentScreen(null);
        this.enchantmentScrollContainer = new TVerticalScrollContainer();
        this.enchantmentScrollContainer.setAbsBounds(enchantmentX, enchantmentY + 13, enchantmentWidth, enchantmentHeight);
        this.enchantmentScrollContainer.setBackground(Integer.MIN_VALUE);
        this.enchantmentScrollContainer.setBorder(new Border(-1, 1));
        this.enchantmentScrollContainer.setParentScreen(null);
        this.refreshEnchantmentDisplay();
        this.updatePanelVisibility();
    }

    private Component getModeText(int mode) {
        return switch (mode) {
            case 0 -> Component.translatable((String)"gui.mafishcrossbow.turret.mode.fixed");
            case 1 -> Component.translatable((String)"gui.mafishcrossbow.turret.mode.auto");
            default -> Component.literal((String)"...");
        };
    }

    private Component getEnabledText(boolean enabled) {
        if (enabled) {
            return Component.translatable((String)"gui.mafishcrossbow.turret.enabled");
        }
        return Component.translatable((String)"gui.mafishcrossbow.turret.disabled");
    }

    private Component getTargetTypeText(int targetType) {
        return switch (targetType) {
            case 1 -> Component.translatable((String)"gui.mafishcrossbow.turret.target.hostile");
            default -> Component.translatable((String)"gui.mafishcrossbow.turret.target.all");
        };
    }

    private void updatePanelVisibility() {
        boolean showControls;
        boolean bl = showControls = this.currentMode == 0 || this.currentMode == 1;
        if (this.yawLabel != null) {
            this.yawLabel.setText((Component)Component.translatable((String)"gui.mafishcrossbow.turret.yaw").append(" " + String.format("%.0f\u00b0", Float.valueOf(this.currentYaw))));
            this.yawLabel.setVisibleT(showControls);
        }
        if (this.pitchLabel != null) {
            this.pitchLabel.setText((Component)Component.translatable((String)"gui.mafishcrossbow.turret.pitch").append(" " + String.format("%.0f\u00b0", Float.valueOf(this.currentPitch))));
            this.pitchLabel.setVisibleT(showControls);
        }
        if (showControls) {
            if (this.yawSlider != null && !this.renderables.contains(this.yawSlider)) {
                this.addRenderableWidget(this.yawSlider);
            }
            if (this.pitchSlider != null && !this.renderables.contains(this.pitchSlider)) {
                this.addRenderableWidget(this.pitchSlider);
            }
        } else {
            if (this.yawSlider != null) {
                this.removeWidget(this.yawSlider);
            }
            if (this.pitchSlider != null) {
                this.removeWidget(this.pitchSlider);
            }
        }
        if (this.yawSlider != null) {
            this.yawSlider.setVisibleT(showControls);
        }
        if (this.pitchSlider != null) {
            this.pitchSlider.setVisibleT(showControls);
        }
        if (this.currentMode == 1) {
            if (this.targetTypeButton != null && !this.renderables.contains(this.targetTypeButton)) {
                this.addRenderableWidget(this.targetTypeButton);
            }
            if (this.manualAimButton != null) {
                this.removeWidget(this.manualAimButton);
            }
        } else if (this.currentMode == 0) {
            if (this.manualAimButton != null && !this.renderables.contains(this.manualAimButton)) {
                this.addRenderableWidget(this.manualAimButton);
            }
            if (this.targetTypeButton != null) {
                this.removeWidget(this.targetTypeButton);
            }
        } else {
            if (this.targetTypeButton != null) {
                this.removeWidget(this.targetTypeButton);
            }
            if (this.manualAimButton != null) {
                this.removeWidget(this.manualAimButton);
            }
        }
    }

    private void refreshEnchantmentDisplay() {
        BlockPos pos;
        if (this.enchantmentScrollContainer == null) {
            return;
        }
        new ArrayList<TWidget>((Collection<TWidget>)this.enchantmentScrollContainer.getChildren()).forEach(this.enchantmentScrollContainer::remove);
        CrossbowTurretBlockEntity blockEntity = ((CrossbowTurretMenu)this.menu).getBlockEntity();
        if (blockEntity == null && (pos = ((CrossbowTurretMenu)this.menu).getBlockPos()) != null && !pos.equals((Object)BlockPos.ZERO)) {
            BlockEntity be;
            Minecraft mc = Minecraft.getInstance();
            if (mc.level != null && (be = mc.level.getBlockEntity(pos)) instanceof CrossbowTurretBlockEntity) {
                CrossbowTurretBlockEntity turret;
                blockEntity = turret = (CrossbowTurretBlockEntity)be;
            }
        }
        if (blockEntity == null) {
            this.hasEnchantments = false;
            return;
        }
        ItemEnchantments enchantments = blockEntity.getEnchantments();
        if (enchantments.isEmpty()) {
            this.hasEnchantments = false;
        } else {
            this.hasEnchantments = true;
            int yOffset = 3;
            for (Object2IntMap.Entry entry : enchantments.entrySet()) {
                Holder enchantmentHolder = (Holder)entry.getKey();
                int level = entry.getIntValue();
                Component enchantmentText = Enchantment.getFullname((Holder)enchantmentHolder, (int)level);
                TLabel enchantmentLabel = new TLabel(enchantmentText);
                enchantmentLabel.setAbsBounds(this.enchantmentScrollContainer.getXT() + 3, this.enchantmentScrollContainer.getYT() + yOffset, this.enchantmentScrollContainer.getWidth() - 12, 10);
                this.enchantmentScrollContainer.add(enchantmentLabel);
                yOffset += 12;
            }
        }
        if (this.enchantmentScrollContainer != null) {
            this.enchantmentScrollContainer.layout();
        }
    }

    private void sendModeUpdate() {
        TurretConfigC2SPacket packet = new TurretConfigC2SPacket(TurretConfigC2SPacket.ConfigType.MODE, this.currentMode);
        ClientPacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void sendYawUpdate() {
        TurretConfigC2SPacket packet = new TurretConfigC2SPacket(TurretConfigC2SPacket.ConfigType.FIXED_YAW, this.currentYaw);
        ClientPacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void sendPitchUpdate() {
        TurretConfigC2SPacket packet = new TurretConfigC2SPacket(TurretConfigC2SPacket.ConfigType.FIXED_PITCH, this.currentPitch);
        ClientPacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void sendEnabledUpdate() {
        TurretConfigC2SPacket packet = new TurretConfigC2SPacket(TurretConfigC2SPacket.ConfigType.ENABLED, this.currentEnabled ? 1.0f : 0.0f);
        ClientPacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void sendTargetTypeUpdate() {
        TurretConfigC2SPacket packet = new TurretConfigC2SPacket(TurretConfigC2SPacket.ConfigType.TARGET_TYPE, this.currentTargetType);
        ClientPacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    protected void containerTick() {
        ItemEnchantments currentEnchantments;
        BlockPos pos;
        CrossbowTurretBlockEntity blockEntity;
        super.containerTick();
        int menuMode = ((CrossbowTurretMenu)this.menu).getMode();
        float menuYaw = ((CrossbowTurretMenu)this.menu).getFixedYaw();
        float menuPitch = ((CrossbowTurretMenu)this.menu).getFixedPitch();
        boolean menuEnabled = ((CrossbowTurretMenu)this.menu).getEnabled();
        int menuTargetType = ((CrossbowTurretMenu)this.menu).getTargetType();
        boolean needsUpdate = false;
        if (menuMode != this.lastSyncedMode) {
            this.lastSyncedMode = menuMode;
            this.currentMode = menuMode;
            if (this.modeButton != null) {
                this.modeButton.setMessage(this.getModeText(this.currentMode));
            }
            needsUpdate = true;
        }
        if (menuEnabled != this.lastSyncedEnabled) {
            this.lastSyncedEnabled = menuEnabled;
            this.currentEnabled = menuEnabled;
            if (this.enabledButton != null) {
                this.enabledButton.setMessage(this.getEnabledText(this.currentEnabled));
            }
        }
        if (menuTargetType != this.lastSyncedTargetType) {
            this.lastSyncedTargetType = menuTargetType;
            this.currentTargetType = menuTargetType;
            if (this.targetTypeButton != null) {
                this.targetTypeButton.setMessage(this.getTargetTypeText(this.currentTargetType));
            }
        }
        if (Float.isNaN(this.lastSyncedYaw) || Math.abs(menuYaw - this.lastSyncedYaw) > 0.01f) {
            this.lastSyncedYaw = menuYaw;
            this.currentYaw = menuYaw;
            if (this.yawSlider != null) {
                this.yawSlider.setAbsValueWithoutRespond(this.currentYaw);
            }
            if (this.yawLabel != null) {
                this.yawLabel.setText((Component)Component.translatable((String)"gui.mafishcrossbow.turret.yaw").append(" " + String.format("%.0f\u00b0", Float.valueOf(this.currentYaw))));
            }
        }
        if (Float.isNaN(this.lastSyncedPitch) || Math.abs(menuPitch - this.lastSyncedPitch) > 0.01f) {
            this.lastSyncedPitch = menuPitch;
            this.currentPitch = menuPitch;
            if (this.pitchSlider != null) {
                this.pitchSlider.setAbsValueWithoutRespond(this.currentPitch);
            }
            if (this.pitchLabel != null) {
                this.pitchLabel.setText((Component)Component.translatable((String)"gui.mafishcrossbow.turret.pitch").append(" " + String.format("%.0f\u00b0", Float.valueOf(this.currentPitch))));
            }
        }
        if (needsUpdate) {
            this.updatePanelVisibility();
        }
        if ((blockEntity = ((CrossbowTurretMenu)this.menu).getBlockEntity()) == null && (pos = ((CrossbowTurretMenu)this.menu).getBlockPos()) != null && !pos.equals((Object)BlockPos.ZERO)) {
            BlockEntity be;
            Minecraft mc = Minecraft.getInstance();
            if (mc.level != null && (be = mc.level.getBlockEntity(pos)) instanceof CrossbowTurretBlockEntity) {
                CrossbowTurretBlockEntity turret;
                blockEntity = turret = (CrossbowTurretBlockEntity)be;
            }
        }
        if (blockEntity != null && !(currentEnchantments = blockEntity.getEnchantments()).equals((Object)this.lastSyncedEnchantments)) {
            this.lastSyncedEnchantments = currentEnchantments;
            this.refreshEnchantmentDisplay();
        }
        this.fixedDirectionPanel.layout();
        if (this.yawLabel != null) {
            this.yawLabel.layout();
        }
        if (this.pitchLabel != null) {
            this.pitchLabel.layout();
        }
        if (this.hasEnchantments) {
            if (this.enchantmentTitleLabel != null) {
                this.enchantmentTitleLabel.layout();
            }
            if (this.enchantmentScrollContainer != null) {
                this.enchantmentScrollContainer.layout();
                this.enchantmentScrollContainer.tickT();
            }
        }
        if (this.yawSlider != null) {
            this.yawSlider.tickT();
        }
        if (this.pitchSlider != null) {
            this.pitchSlider.tickT();
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTurretPreview(guiGraphics, partialTick);
        if (this.currentMode == 0 || this.currentMode == 1) {
            this.fixedDirectionPanel.render(guiGraphics, mouseX, mouseY, partialTick);
            if (this.yawLabel != null) {
                this.yawLabel.render(guiGraphics, mouseX, mouseY, partialTick);
            }
            if (this.pitchLabel != null) {
                this.pitchLabel.render(guiGraphics, mouseX, mouseY, partialTick);
            }
        }
        if (this.hasEnchantments) {
            if (this.enchantmentTitleLabel != null) {
                this.enchantmentTitleLabel.render(guiGraphics, mouseX, mouseY, partialTick);
            }
            if (this.enchantmentScrollContainer != null) {
                this.enchantmentScrollContainer.render(guiGraphics, mouseX, mouseY, partialTick);
            }
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderTurretPreview(GuiGraphics guiGraphics, float partialTick) {
        CrossbowTurretBlockEntity blockEntity = null;
        if (((CrossbowTurretMenu)this.menu).getBlockEntity() != null) {
            blockEntity = ((CrossbowTurretMenu)this.menu).getBlockEntity();
        } else {
            BlockPos pos = ((CrossbowTurretMenu)this.menu).getBlockPos();
            if (pos != null && !pos.equals((Object)BlockPos.ZERO)) {
                BlockEntity be;
                Minecraft mc = Minecraft.getInstance();
                if (mc.level != null && (be = mc.level.getBlockEntity(pos)) instanceof CrossbowTurretBlockEntity) {
                    CrossbowTurretBlockEntity turret;
                    blockEntity = turret = (CrossbowTurretBlockEntity)be;
                }
            }
        }
        if (blockEntity == null) {
            return;
        }
        int previewSize = 60;
        int x0 = this.leftPos - 65;
        int y0 = this.topPos + 15;
        int x1 = x0 + previewSize;
        int y1 = y0 + previewSize;
        int origBorderX0 = x0 - RenderDebugConfig.borderPaddingLeft;
        int origBorderY0 = this.topPos;
        int origBorderX1 = x1 + RenderDebugConfig.borderPaddingRight;
        int origBorderY1 = y1 + RenderDebugConfig.borderPaddingBottom;
        float borderCenterX = (float)(origBorderX0 + origBorderX1) / 2.0f;
        float borderCenterY = (float)(origBorderY0 + origBorderY1) / 2.0f;
        float scaledBorderWidth = (float)(origBorderX1 - origBorderX0) * RenderDebugConfig.borderScale;
        float scaledBorderHeight = (float)(origBorderY1 - origBorderY0) * RenderDebugConfig.borderScale;
        int borderX0 = Math.round(borderCenterX - scaledBorderWidth / 2.0f);
        int borderY0 = Math.round(borderCenterY - scaledBorderHeight / 2.0f);
        int borderX1 = Math.round(borderCenterX + scaledBorderWidth / 2.0f);
        int borderY1 = Math.round(borderCenterY + scaledBorderHeight / 2.0f);
        guiGraphics.fill(borderX0, borderY0, borderX1, borderY1, Integer.MIN_VALUE);
        guiGraphics.renderOutline(borderX0, borderY0, borderX1 - borderX0, borderY1 - borderY0, -1);
        GuiGraphicsHelper.renderBlockEntityInGui(guiGraphics, (BlockEntity)blockEntity, partialTick, x0, y0, x1, y1, 30.0f, false);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.modeButton != null && this.modeButton.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.enabledButton != null && this.enabledButton.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if ((this.currentMode == 0 || this.currentMode == 1) && this.fixedDirectionPanel.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.hasEnchantments && this.enchantmentScrollContainer != null && this.enchantmentScrollContainer.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if ((this.currentMode == 0 || this.currentMode == 1) && this.fixedDirectionPanel.mouseScrolled(mouseX, mouseY, deltaX, deltaY)) {
            return true;
        }
        if (this.hasEnchantments && this.enchantmentScrollContainer != null && this.enchantmentScrollContainer.mouseScrolled(mouseX, mouseY, deltaX, deltaY)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, deltaX, deltaY);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.currentMode == 0 || this.currentMode == 1) {
            if (this.yawSlider != null && this.yawSlider.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
                return true;
            }
            if (this.pitchSlider != null && this.pitchSlider.mouseDragged(mouseX, mouseY, button, dragX, dragY)) {
                return true;
            }
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }
}

