/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.gui;

import com.mafuyu33.mafishcrossbow.gui.ModMenuTypes;
import com.mafuyu33.mafishcrossbow.item.ModItems;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringUtil;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class EnchantmentTableMenu
extends AbstractContainerMenu {
    private static final int INPUT_SLOT = 0;
    private static final int MATERIAL_SLOT = 1;
    private static final int RESULT_SLOT = 2;
    private final Container container;
    private final Player player;
    private final DataSlot cost = DataSlot.standalone();
    private final Map<Holder<Enchantment>, Integer> tempEnchantments = new HashMap<Holder<Enchantment>, Integer>();
    private ItemStack lastInputItem = ItemStack.EMPTY;
    @Nullable
    private String itemName;

    public EnchantmentTableMenu(int containerId, Inventory playerInventory) {
        this(containerId, playerInventory, (Container)new SimpleContainer(3));
    }

    public EnchantmentTableMenu(int containerId, Inventory playerInventory, Container container) {
        super((MenuType)ModMenuTypes.ENCHANTMENT_TABLE.get(), containerId);
        this.container = container;
        this.player = playerInventory.player;
        this.addDataSlot(this.cost);
        this.addSlot(new Slot(container, 0, 27, 47){

            public boolean mayPlace(ItemStack stack) {
                return EnchantmentHelper.canStoreEnchantments((ItemStack)stack);
            }

            public void setChanged() {
                super.setChanged();
                EnchantmentTableMenu.this.slotsChanged(this.container);
            }

            public void onTake(Player player, ItemStack stack) {
                super.onTake(player, stack);
                EnchantmentTableMenu.this.slotsChanged(this.container);
            }
        });
        this.addSlot(new Slot(container, 1, 76, 47){

            public boolean mayPlace(ItemStack stack) {
                return stack.is((Item)ModItems.MAFISH.get());
            }

            public void setChanged() {
                super.setChanged();
                EnchantmentTableMenu.this.slotsChanged(this.container);
            }

            public void onTake(Player player, ItemStack stack) {
                super.onTake(player, stack);
                EnchantmentTableMenu.this.slotsChanged(this.container);
            }
        });
        this.addSlot(new Slot(container, 2, 134, 47){

            public boolean mayPlace(ItemStack stack) {
                return false;
            }

            public boolean mayPickup(Player player) {
                return !this.container.getItem(1).isEmpty();
            }

            public void onTake(Player player, ItemStack stack) {
                this.container.setItem(0, ItemStack.EMPTY);
                if (!player.hasInfiniteMaterials()) {
                    player.giveExperienceLevels(-EnchantmentTableMenu.this.cost.get());
                    ItemStack mafish = this.container.getItem(1);
                    mafish.shrink(1);
                    if (mafish.isEmpty()) {
                        this.container.setItem(1, ItemStack.EMPTY);
                    }
                }
                EnchantmentTableMenu.this.tempEnchantments.clear();
                EnchantmentTableMenu.this.cost.set(0);
                super.onTake(player, stack);
            }
        });
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, 8 + col * 18, 142));
        }
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index == 2) {
                if (!this.moveItemStackTo(itemstack1, 3, 39, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index == 0 || index == 1 ? !this.moveItemStackTo(itemstack1, 3, 39, false) : (itemstack1.is((Item)ModItems.MAFISH.get()) ? !this.moveItemStackTo(itemstack1, 1, 2, false) : (EnchantmentHelper.canStoreEnchantments((ItemStack)itemstack1) ? !this.moveItemStackTo(itemstack1, 0, 1, false) : (index >= 3 && index < 30 ? !this.moveItemStackTo(itemstack1, 30, 39, false) : index >= 30 && index < 39 && !this.moveItemStackTo(itemstack1, 3, 30, false))))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    public void removed(Player player) {
        super.removed(player);
        if (!player.level().isClientSide) {
            this.clearContainer(player, this.container);
        }
    }

    public Container getContainer() {
        return this.container;
    }

    public ItemStack getInputItem() {
        return this.container.getItem(0);
    }

    public void setResultItem(ItemStack stack) {
        this.container.setItem(2, stack);
    }

    public void addEnchantment(Holder<Enchantment> enchantment, int level) {
        this.tempEnchantments.put(enchantment, level);
    }

    public void removeEnchantment(Holder<Enchantment> enchantment) {
        this.tempEnchantments.remove(enchantment);
    }

    public void setEnchantmentLevel(Holder<Enchantment> enchantment, int level) {
        int maxLevel;
        int n = maxLevel = this.player.hasInfiniteMaterials() ? 255 : ((Enchantment)enchantment.value()).getMaxLevel();
        if (level > 0 && level <= maxLevel) {
            this.tempEnchantments.put(enchantment, level);
        }
    }

    public Map<Holder<Enchantment>, Integer> getTempEnchantments() {
        return this.tempEnchantments;
    }

    public void clearTempEnchantments() {
        this.tempEnchantments.clear();
    }

    public void createResult() {
        ItemStack inputItem = this.container.getItem(0);
        ItemStack mafishItem = this.container.getItem(1);
        if (inputItem.isEmpty()) {
            this.container.setItem(2, ItemStack.EMPTY);
            this.cost.set(0);
            this.tempEnchantments.clear();
            return;
        }
        if (mafishItem.isEmpty()) {
            this.container.setItem(2, ItemStack.EMPTY);
            this.cost.set(0);
            return;
        }
        ItemStack result = inputItem.copy();
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        for (Map.Entry<Holder<Enchantment>, Integer> entry : this.tempEnchantments.entrySet()) {
            mutable.set(entry.getKey(), entry.getValue().intValue());
        }
        EnchantmentHelper.setEnchantments((ItemStack)result, (ItemEnchantments)mutable.toImmutable());
        if (this.itemName != null && !StringUtil.isBlank((String)this.itemName) && !this.itemName.equals(inputItem.getHoverName().getString())) {
            result.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)this.itemName));
        }
        int totalCost = 0;
        for (int level : this.tempEnchantments.values()) {
            totalCost += level;
        }
        this.cost.set(totalCost);
        this.container.setItem(2, result);
        this.broadcastChanges();
    }

    public int getCost() {
        return this.cost.get();
    }

    public boolean setItemName(String name) {
        String validatedName = EnchantmentTableMenu.validateName(name);
        if (validatedName != null && !validatedName.equals(this.itemName)) {
            this.itemName = validatedName;
            this.createResult();
            return true;
        }
        return false;
    }

    @Nullable
    private static String validateName(String name) {
        String filtered = StringUtil.filterText((String)name);
        return filtered.length() <= 50 ? filtered : null;
    }

    public void slotsChanged(Container container) {
        super.slotsChanged(container);
        if (container == this.container) {
            boolean inputItemChanged;
            ItemStack inputItem = container.getItem(0);
            boolean bl = inputItemChanged = !ItemStack.isSameItemSameComponents((ItemStack)inputItem, (ItemStack)this.lastInputItem);
            if (inputItemChanged) {
                if (!inputItem.isEmpty()) {
                    this.tempEnchantments.clear();
                    ItemEnchantments enchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)inputItem);
                    for (Object2IntMap.Entry entry : enchantments.entrySet()) {
                        this.tempEnchantments.put((Holder<Enchantment>)((Holder)entry.getKey()), entry.getIntValue());
                    }
                } else {
                    this.tempEnchantments.clear();
                }
                this.lastInputItem = inputItem.copy();
            }
            this.createResult();
        }
    }
}

