/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.gui.render;

import com.mafuyu33.mafishcrossbow.gui.render.state.GuiBlockEntityRenderState;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class GuiBlockEntityRenderer
extends PictureInPictureRenderer<GuiBlockEntityRenderState> {
    private final BlockEntityRenderDispatcher blockEntityRenderDispatcher = Minecraft.getInstance().getBlockEntityRenderDispatcher();

    public GuiBlockEntityRenderer(MultiBufferSource.BufferSource bufferSource) {
        super(bufferSource);
    }

    public Class<GuiBlockEntityRenderState> getRenderStateClass() {
        return GuiBlockEntityRenderState.class;
    }

    protected void renderToTexture(GuiBlockEntityRenderState renderState, PoseStack poseStack) {
        BlockEntityRenderer renderer;
        poseStack.pushPose();
        Minecraft.getInstance().gameRenderer.getLighting().setupFor(Lighting.Entry.ENTITY_IN_UI);
        poseStack.last().setIdentity();
        float scale = (float)Minecraft.getInstance().getWindow().getGuiScale() * renderState.scale();
        poseStack.scale(scale, scale, -scale);
        poseStack.translate(0.5, 0.5, 0.5);
        poseStack.rotateAround((Quaternionfc)Axis.XP.rotationDegrees(180.0f - renderState.playerPitch()), 0.5f, 0.5f, 0.5f);
        poseStack.rotateAround((Quaternionfc)Axis.YP.rotationDegrees(180.0f - renderState.playerYaw()), 0.5f, 0.5f, 0.5f);
        BlockEntity blockEntity = renderState.blockEntity();
        if (blockEntity != null && (renderer = this.blockEntityRenderDispatcher.getRenderer(blockEntity)) != null) {
            renderer.render(blockEntity, renderState.partialTick(), poseStack, (MultiBufferSource)this.bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY, Vec3.ZERO);
        }
        poseStack.popPose();
    }

    protected float getTranslateY(int height, int guiScale) {
        return (float)height / 2.0f + 100.0f;
    }

    protected String getTextureLabel() {
        return "block_entity";
    }
}

