/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.gui.render;

import com.mafuyu33.mafishcrossbow.gui.render.state.GuiBlockEntityRenderState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class GuiGraphicsHelper {
    public static void renderBlockEntityInGui(GuiGraphics guiGraphics, BlockEntity blockEntity, float partialTick, int x0, int y0, int x1, int y1, float scale) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        float playerYaw = 0.0f;
        float playerPitch = 0.0f;
        if (player != null) {
            BlockPos blockPos = blockEntity.getBlockPos();
            Vec3 blockCenter = new Vec3((double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5);
            Vec3 playerEyes = player.getEyePosition(partialTick);
            Vec3 lookVector = blockCenter.subtract(playerEyes);
            double dx = lookVector.x;
            double dy = lookVector.y;
            double dz = lookVector.z;
            double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
            playerPitch = (float)Math.toDegrees(Math.atan2(dy, horizontalDistance));
            playerYaw = (float)Math.toDegrees(Math.atan2(dx, dz));
        }
        GuiBlockEntityRenderState renderState = new GuiBlockEntityRenderState(blockEntity, partialTick, x0, y0, x1, y1, scale, playerYaw, playerPitch, guiGraphics.peekScissorStack());
        guiGraphics.submitPictureInPictureRenderState((PictureInPictureRenderState)renderState);
    }

    public static void renderBlockEntityInGui(GuiGraphics guiGraphics, BlockEntity blockEntity, float partialTick, int x0, int y0, int x1, int y1, float scale, boolean enableScissor) {
        if (enableScissor) {
            guiGraphics.enableScissor(x0, y0, x1, y1);
        }
        GuiGraphicsHelper.renderBlockEntityInGui(guiGraphics, blockEntity, partialTick, x0, y0, x1, y1, scale);
        if (enableScissor) {
            guiGraphics.disableScissor();
        }
    }
}

