/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.item;

import com.mafuyu33.mafishcrossbow.block.ModBlocks;
import com.mafuyu33.mafishcrossbow.enchantment.datagen.custom.ModEnchantments;
import com.mafuyu33.mafishcrossbow.item.MafishItem;
import com.mafuyu33.mafishcrossbow.item.ShulkerBulletItem;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.network.Filterable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModItems {
    private static final boolean IS_ENGLISH = true;
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"mafishcrossbow");
    public static final DeferredItem<Item> MAFISH = ITEMS.register("mafish", () -> new MafishItem(ModItems.itemProps("mafish").fireResistant().equippable(EquipmentSlot.HEAD).component(DataComponents.LORE, (Object)new ItemLore(List.of(Component.translatable((String)"tooltip.mafishcrossbow.book.mafish.line1").withStyle(ChatFormatting.DARK_GRAY), Component.translatable((String)"tooltip.mafishcrossbow.book.mafish.line2").withStyle(ChatFormatting.DARK_GRAY)))).component(DataComponents.TOOLTIP_DISPLAY, (Object)TooltipDisplay.DEFAULT.withHidden(DataComponents.LORE, false))));
    public static final DeferredItem<Item> CROSSBOW_DISPENSER = ITEMS.register("crossbow_dispenser", () -> new BlockItem((Block)ModBlocks.CROSSBOW_DISPENSER.get(), ModItems.itemProps("crossbow_dispenser")));
    public static final DeferredItem<Item> ENCHANTMENT_TABLE = ITEMS.register("enchantment_table", () -> new BlockItem((Block)ModBlocks.ENCHANTMENT_TABLE.get(), ModItems.itemProps("enchantment_table")));
    public static final DeferredItem<Item> CROSSBOW_TURRET = ITEMS.register("crossbow_turret", () -> new BlockItem((Block)ModBlocks.CROSSBOW_TURRET.get(), ModItems.itemProps("crossbow_turret")));
    public static final DeferredItem<Item> CROSSBOW_PRESET_WORKBENCH = ITEMS.register("crossbow_preset_workbench", () -> new BlockItem((Block)ModBlocks.CROSSBOW_PRESET_WORKBENCH.get(), ModItems.itemProps("crossbow_preset_workbench")));
    public static final DeferredItem<Item> CROSSBOW_GUIDE_BOOK = ITEMS.register("crossbow_guide_book", () -> new WrittenBookItem(ModItems.itemProps("crossbow_guide_book").stacksTo(1).component(DataComponents.WRITTEN_BOOK_CONTENT, (Object)ModItems.createCrossbowGuideBookContent())));
    public static final DeferredItem<Item> SHULKER_BULLET = ITEMS.register("shulker_bullet", () -> new ShulkerBulletItem(ModItems.itemProps("shulker_bullet").stacksTo(64)));

    private static Map<String, ResourceKey<Enchantment>> getAllEnchantments() {
        LinkedHashMap<String, ResourceKey<Enchantment>> enchantments = new LinkedHashMap<String, ResourceKey<Enchantment>>();
        try {
            Field[] fields;
            for (Field field : fields = ModEnchantments.class.getDeclaredFields()) {
                if (field.getType() != ResourceKey.class) continue;
                field.setAccessible(true);
                Object value = field.get(null);
                if (!(value instanceof ResourceKey)) continue;
                ResourceKey key = (ResourceKey)value;
                String name = field.getName().toLowerCase();
                enchantments.put(name, (ResourceKey<Enchantment>)key);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return enchantments;
    }

    private static boolean isCurse(String enchantName) {
        return enchantName.equals("bad_luck_of_sea") || enchantName.equals("bowleft") || enchantName.equals("bowright") || enchantName.equals("decrease_initial_speed") || enchantName.equals("decrease_lifetime");
    }

    private static String getEnchantmentCategory(String enchantName) {
        if (enchantName.contains("tracking") || enchantName.contains("bounce") || enchantName.contains("gravity") || enchantName.contains("antigravity") || enchantName.equals("nogravity") || enchantName.contains("bow")) {
            return "\u79fb\u52a8\u7c7b";
        }
        if (enchantName.contains("speed") || enchantName.contains("accelerate") || enchantName.contains("decelerate")) {
            return "\u901f\u5ea6\u7c7b";
        }
        if (enchantName.equals("bad_luck_of_sea")) {
            return "\u7279\u6b8a\u7c7b";
        }
        return "\u529f\u80fd\u7c7b";
    }

    private static String getEnchantmentCategoryKey(String category) {
        return switch (category) {
            case "\u79fb\u52a8\u7c7b" -> "movement";
            case "\u901f\u5ea6\u7c7b" -> "speed";
            case "\u7279\u6b8a\u7c7b" -> "special";
            case "\u529f\u80fd\u7c7b" -> "function";
            default -> "function";
        };
    }

    private static WrittenBookContent createCrossbowGuideBookContent() {
        ArrayList<Filterable> pages = new ArrayList<Filterable>();
        pages.add(Filterable.passThrough((Object)Component.empty().append((Component)Component.translatable((String)"guidebook.mafishcrossbow.title")).append("\n\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.author")).append("\n\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.intro"))));
        pages.add(Filterable.passThrough((Object)Component.empty().append((Component)Component.translatable((String)"guidebook.mafishcrossbow.contents")).append("\n\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.page2")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.page3_4")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.page5_6")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.page7")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.page8_9")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.page10_plus")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.page_second_last")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.page_last"))));
        pages.add(Filterable.passThrough((Object)Component.empty().append((Component)Component.translatable((String)"guidebook.mafishcrossbow.basic_intro.title")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.basic_intro.content1")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.basic_intro.features")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.basic_intro.feature1")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.basic_intro.feature2")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.basic_intro.feature3")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.basic_intro.feature4")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.basic_intro.start"))));
        pages.add(Filterable.passThrough((Object)Component.empty().append((Component)Component.translatable((String)"guidebook.mafishcrossbow.nested_fire.title")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.nested_fire.desc")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.nested_fire.how")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.nested_fire.step1")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.nested_fire.step2")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.nested_fire.step3")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.nested_fire.step4")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.nested_fire.infinite"))));
        pages.add(Filterable.passThrough((Object)Component.empty().append((Component)Component.translatable((String)"guidebook.mafishcrossbow.nested_tips.title")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.nested_tips.multishot")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.nested_tips.notes")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.nested_tips.note1")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.nested_tips.note2")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.nested_tips.tip"))));
        pages.add(Filterable.passThrough((Object)Component.empty().append((Component)Component.translatable((String)"guidebook.mafishcrossbow.bundle_system.title")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.bundle_system.desc")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.bundle_system.usage")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.bundle_system.step1")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.bundle_system.step2")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.bundle_system.step3")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.bundle_system.result"))));
        pages.add(Filterable.passThrough((Object)Component.empty().append((Component)Component.translatable((String)"guidebook.mafishcrossbow.firework_burst.title")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.firework_burst.desc")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.firework_burst.mechanics")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.firework_burst.mech1")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.firework_burst.mech2")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.firework_burst.mech3")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.firework_burst.mech4")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.firework_burst.try"))));
        pages.add(Filterable.passThrough((Object)Component.empty().append((Component)Component.translatable((String)"guidebook.mafishcrossbow.shulker_magazine.title")).append("\n\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.shulker_magazine.desc")).append("\n\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.shulker_magazine.usage")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.shulker_magazine.usage1")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.shulker_magazine.usage2"))));
        pages.add(Filterable.passThrough((Object)Component.empty().append((Component)Component.translatable((String)"guidebook.mafishcrossbow.shulker_magazine.enchant")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.shulker_magazine.enchant1")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.shulker_magazine.enchant2")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.shulker_magazine.enchant3")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.shulker_magazine.enchant4")).append("\n\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.shulker_magazine.tip"))));
        pages.add(Filterable.passThrough((Object)Component.empty().append((Component)Component.translatable((String)"guidebook.mafishcrossbow.enchant_system.title")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.enchant_system.desc")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.enchant_system.applies")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.enchant_system.apply1")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.enchant_system.apply2")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.enchant_system.pages"))));
        Map<String, ResourceKey<Enchantment>> enchantments = ModItems.getAllEnchantments();
        LinkedHashMap<String, List> categorizedEnchants = new LinkedHashMap<String, List>();
        for (String enchantName : enchantments.keySet()) {
            String category = ModItems.getEnchantmentCategory(enchantName);
            categorizedEnchants.computeIfAbsent(category, k -> new ArrayList()).add(enchantName);
        }
        int pageNum = 11;
        for (Map.Entry categoryEntry : categorizedEnchants.entrySet()) {
            String category = (String)categoryEntry.getKey();
            List enchantList = (List)categoryEntry.getValue();
            int enchantsPerPage = 8;
            for (int i = 0; i < enchantList.size(); i += enchantsPerPage) {
                MutableComponent page = Component.empty();
                page.append((Component)Component.translatable((String)("guidebook.mafishcrossbow.enchant_category." + ModItems.getEnchantmentCategoryKey(category))));
                page.append((Component)Component.translatable((String)"guidebook.mafishcrossbow.enchant_category.suffix"));
                if (enchantList.size() > enchantsPerPage) {
                    page.append((Component)Component.literal((String)(" (" + (i / enchantsPerPage + 1) + "/" + (enchantList.size() + enchantsPerPage - 1) / enchantsPerPage + ")")));
                }
                page.append((Component)Component.literal((String)"\n"));
                for (int j = i; j < Math.min(i + enchantsPerPage, enchantList.size()); ++j) {
                    String enchantName = (String)enchantList.get(j);
                    boolean isCurse = ModItems.isCurse(enchantName);
                    String translationKey = "enchantment.mafishcrossbow." + enchantName;
                    MutableComponent displayName = Component.translatable((String)translationKey);
                    page.append((Component)Component.literal((String)(isCurse ? "\u00a7c" : "\u00a7d")));
                    page.append((Component)displayName);
                    page.append((Component)Component.literal((String)("\u00a7r (" + enchantName + ")")));
                    if (j >= Math.min(i + enchantsPerPage - 1, enchantList.size() - 1)) continue;
                    page.append((Component)Component.literal((String)"\n"));
                }
                pages.add(Filterable.passThrough((Object)page));
                ++pageNum;
            }
        }
        pages.add(Filterable.passThrough((Object)Component.empty().append((Component)Component.translatable((String)"guidebook.mafishcrossbow.advanced_enchant.title")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.advanced_enchant.desc")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.advanced_enchant.format")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.advanced_enchant.cmd1")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.advanced_enchant.cmd2")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.advanced_enchant.cmd3")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.advanced_enchant.cmd4")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.advanced_enchant.modid")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.advanced_enchant.modid_value"))));
        pages.add(Filterable.passThrough((Object)Component.empty().append((Component)Component.translatable((String)"guidebook.mafishcrossbow.example_commands.title")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.example_commands.example1")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.example_commands.cmd1_1")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.example_commands.cmd1_2")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.example_commands.cmd1_3")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.example_commands.cmd1_4")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.example_commands.cmd1_5")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.example_commands.example2")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.example_commands.cmd2_1")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.example_commands.cmd2_2")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.example_commands.cmd2_3")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.example_commands.cmd2_4"))));
        pages.add(Filterable.passThrough((Object)Component.empty().append((Component)Component.translatable((String)"guidebook.mafishcrossbow.advanced_tips.title")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.advanced_tips.tip1")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.advanced_tips.tip2")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.advanced_tips.tip3")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.advanced_tips.tip4")).append("\n").append((Component)Component.translatable((String)"guidebook.mafishcrossbow.advanced_tips.farewell"))));
        return new WrittenBookContent(Filterable.passThrough((Object)"\u5f29\u4ece\u5165\u95e8\u5230\u7cbe\u901a"), "\u9a6c\u592b\u9c7c", 0, pages, true);
    }

    public static Item.Properties itemProps(String name) {
        return new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mafishcrossbow", (String)name)));
    }
}

