/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixin.client.test;

import com.mafuyu33.mafishcrossbow.client.SpeedTestClientHandler;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LocalPlayer.class})
public abstract class PlayerSpeedDisplayMixin {
    @Unique
    private Vec3 mafishcrossbow$lastPos = null;
    @Unique
    private int mafishcrossbow$tickCounter = 0;
    @Unique
    private double mafishcrossbow$maxSpeed = 0.0;
    @Unique
    private double mafishcrossbow$maxHorizontalSpeed = 0.0;
    @Unique
    private double mafishcrossbow$maxVerticalSpeed = 0.0;

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void mafishcrossbow$displaySpeed(CallbackInfo ci) {
        LocalPlayer player = (LocalPlayer)this;
        if (SpeedTestClientHandler.shouldResetMaxSpeed) {
            this.mafishcrossbow$maxSpeed = 0.0;
            this.mafishcrossbow$maxHorizontalSpeed = 0.0;
            this.mafishcrossbow$maxVerticalSpeed = 0.0;
            SpeedTestClientHandler.shouldResetMaxSpeed = false;
        }
        if (!SpeedTestClientHandler.isSpeedDisplayEnabled) {
            return;
        }
        if (this.mafishcrossbow$lastPos == null) {
            this.mafishcrossbow$lastPos = player.position();
            return;
        }
        ++this.mafishcrossbow$tickCounter;
        if (this.mafishcrossbow$tickCounter % 2 != 0) {
            return;
        }
        Vec3 currentPos = player.position();
        double deltaX = currentPos.x - this.mafishcrossbow$lastPos.x;
        double deltaY = currentPos.y - this.mafishcrossbow$lastPos.y;
        double deltaZ = currentPos.z - this.mafishcrossbow$lastPos.z;
        double horizontalSpeed = Math.sqrt(deltaX * deltaX + deltaZ * deltaZ);
        double verticalSpeed = Math.abs(deltaY);
        double totalSpeed = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
        horizontalSpeed *= 10.0;
        verticalSpeed *= 10.0;
        if ((totalSpeed *= 10.0) > this.mafishcrossbow$maxSpeed) {
            this.mafishcrossbow$maxSpeed = totalSpeed;
        }
        if (horizontalSpeed > this.mafishcrossbow$maxHorizontalSpeed) {
            this.mafishcrossbow$maxHorizontalSpeed = horizontalSpeed;
        }
        if (verticalSpeed > this.mafishcrossbow$maxVerticalSpeed) {
            this.mafishcrossbow$maxVerticalSpeed = verticalSpeed;
        }
        StringBuilder speedInfo = new StringBuilder();
        if (player.getVehicle() != null) {
            String vehicleName = player.getVehicle().getDisplayName().getString();
            speedInfo.append(String.format("\u00a7d[\u9a91\u4e58: %s] ", vehicleName));
        }
        speedInfo.append(String.format("\u00a7b\u901f\u5ea6: \u00a7f%.1f \u00a77b/s | \u00a7a\u6c34\u5e73: \u00a7f%.1f \u00a77b/s | ", totalSpeed, horizontalSpeed));
        if (deltaY > 0.001) {
            speedInfo.append(String.format("\u00a7e\u2191 %.1f \u00a77b/s", verticalSpeed));
        } else if (deltaY < -0.001) {
            speedInfo.append(String.format("\u00a7c\u2193 %.1f \u00a77b/s", verticalSpeed));
        } else {
            speedInfo.append("\u00a77= 0.0 b/s");
        }
        speedInfo.append(String.format(" \u00a77| \u00a76\u6700\u9ad8: \u00a7e%.1f \u00a77b/s", this.mafishcrossbow$maxSpeed));
        player.displayClientMessage((Component)Component.literal((String)speedInfo.toString()), true);
        this.mafishcrossbow$lastPos = currentPos;
    }
}

