/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixin.enchantment.autoload;

import com.mafuyu33.mafishcrossbow.enchantment.ModEnchantmentHelper;
import com.mafuyu33.mafishcrossbow.enchantment.datagen.custom.ModEnchantments;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CrossbowItem.class})
public abstract class CrossbowItemMixin {
    @Unique
    private static final ThreadLocal<Boolean> mafishcrossbow$isAutoloadRunning = ThreadLocal.withInitial(() -> false);
    @Unique
    private static final ThreadLocal<Long> mafishcrossbow$lastShootTime = ThreadLocal.withInitial(() -> 0L);
    @Unique
    private static final ThreadLocal<ChargedProjectiles> mafishcrossbow$lastProjectiles = new ThreadLocal();

    @Inject(method={"use"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleAutoloadUse(Level level, Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack stack = player.getItemInHand(hand);
        if (ModEnchantmentHelper.getEnchantmentLevel(ModEnchantments.AUTOLOAD, stack) > 0) {
            ChargedProjectiles chargedprojectiles = (ChargedProjectiles)stack.get(DataComponents.CHARGED_PROJECTILES);
            if (chargedprojectiles != null && !chargedprojectiles.isEmpty()) {
                CrossbowItem crossbow = (CrossbowItem)this;
                float power = chargedprojectiles.contains(Items.FIREWORK_ROCKET) ? 1.6f : 3.15f;
                crossbow.performShooting(level, (LivingEntity)player, hand, stack, power, 1.0f, null);
                cir.setReturnValue((Object)InteractionResult.CONSUME);
            } else {
                BlockItem blockItem;
                Item item2;
                mafishcrossbow$lastProjectiles.remove();
                ItemStack offhand = player.getOffhandItem();
                if (!offhand.isEmpty() && (item2 = offhand.getItem()) instanceof BlockItem && (blockItem = (BlockItem)item2).getBlock() instanceof ShulkerBoxBlock) {
                    boolean hasItems;
                    ItemContainerContents container = (ItemContainerContents)offhand.get(DataComponents.CONTAINER);
                    if (container != null && (hasItems = container.stream().anyMatch(item -> !item.isEmpty()))) {
                        player.startUsingItem(hand);
                        cir.setReturnValue((Object)InteractionResult.CONSUME);
                        return;
                    }
                    cir.setReturnValue((Object)InteractionResult.FAIL);
                    return;
                }
                player.startUsingItem(hand);
                cir.setReturnValue((Object)InteractionResult.CONSUME);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"onUseTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void injectRapidfire(Level level, LivingEntity livingEntity, ItemStack stack, int count, CallbackInfo ci) {
        int autoloadLevel = ModEnchantmentHelper.getEnchantmentLevel(ModEnchantments.AUTOLOAD, stack);
        if (!level.isClientSide && autoloadLevel > 0) {
            long shootDelay;
            if (mafishcrossbow$isAutoloadRunning.get().booleanValue()) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            switch (autoloadLevel) {
                case 1: {
                    long l = 200L;
                    break;
                }
                case 2: {
                    long l = 100L;
                    break;
                }
                case 3: {
                    long l = 50L;
                    break;
                }
                default: {
                    long l = shootDelay = 0L;
                }
            }
            if (currentTime - mafishcrossbow$lastShootTime.get() < shootDelay) {
                return;
            }
            mafishcrossbow$isAutoloadRunning.set(true);
            try {
                boolean hasInfinity = ModEnchantmentHelper.getEnchantmentLevel((ResourceKey<Enchantment>)Enchantments.INFINITY, stack) > 0;
                ChargedProjectiles savedProjectiles = mafishcrossbow$lastProjectiles.get();
                boolean hasOffhandItem = false;
                if (livingEntity instanceof Player) {
                    Player player = (Player)livingEntity;
                    boolean bl = hasOffhandItem = !player.getOffhandItem().isEmpty();
                }
                if (hasInfinity && savedProjectiles != null && !savedProjectiles.isEmpty() && currentTime - mafishcrossbow$lastShootTime.get() < 300L && !hasOffhandItem) {
                    stack.set(DataComponents.CHARGED_PROJECTILES, (Object)savedProjectiles);
                    CrossbowItem crossbow = (CrossbowItem)this;
                    float power = savedProjectiles.contains(Items.FIREWORK_ROCKET) ? 1.6f : 3.15f;
                    crossbow.performShooting(level, livingEntity, livingEntity.getUsedItemHand(), stack, power, 1.0f, null);
                    mafishcrossbow$lastShootTime.set(currentTime);
                } else if (CrossbowItem.tryLoadProjectiles((LivingEntity)livingEntity, (ItemStack)stack)) {
                    ChargedProjectiles chargedprojectiles = (ChargedProjectiles)stack.get(DataComponents.CHARGED_PROJECTILES);
                    if (chargedprojectiles != null && !chargedprojectiles.isEmpty()) {
                        if (hasInfinity) {
                            mafishcrossbow$lastProjectiles.set(chargedprojectiles);
                        }
                        CrossbowItem crossbow = (CrossbowItem)this;
                        float power = chargedprojectiles.contains(Items.FIREWORK_ROCKET) ? 1.6f : 3.15f;
                        crossbow.performShooting(level, livingEntity, livingEntity.getUsedItemHand(), stack, power, 1.0f, null);
                        mafishcrossbow$lastShootTime.set(currentTime);
                    }
                } else {
                    mafishcrossbow$lastProjectiles.remove();
                }
                ci.cancel();
            }
            finally {
                mafishcrossbow$isAutoloadRunning.set(false);
            }
        }
    }

    @Inject(method={"releaseUsing"}, at={@At(value="HEAD")}, cancellable=true)
    private void preventNormalRelease(ItemStack stack, Level level, LivingEntity user, int timeLeft, CallbackInfoReturnable<Boolean> cir) {
        if (ModEnchantmentHelper.getEnchantmentLevel(ModEnchantments.AUTOLOAD, stack) > 0) {
            cir.setReturnValue((Object)true);
        }
    }
}

