/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixin.enchantment.badluckofsea;

import com.mafuyu33.mafishcrossbow.enchantment.ModEnchantmentHelper;
import com.mafuyu33.mafishcrossbow.enchantment.datagen.custom.ModEnchantments;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class BadLuckOfSeaItemEntityMixin
extends Entity
implements TraceableEntity {
    public BadLuckOfSeaItemEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Shadow
    public abstract ItemStack getItem();

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void init(CallbackInfo ci) {
        BlockPos blockPos;
        ItemStack itemStack = this.getItem();
        Item item = itemStack.getItem();
        Level world = this.level();
        FluidState fluidState = world.getFluidState(blockPos = this.blockPosition());
        if (fluidState.is(FluidTags.WATER) & ModEnchantmentHelper.getEnchantmentLevel(ModEnchantments.BAD_LUCK_OF_SEA, itemStack) > 0) {
            BlockPos closestNonLiquidBlockPos = null;
            double closestDistanceSq = Double.MAX_VALUE;
            for (int xOffset = -20; xOffset <= 19; ++xOffset) {
                for (int zOffset = -20; zOffset <= 19; ++zOffset) {
                    double distanceSq;
                    BlockPos currentPos = blockPos.offset(xOffset, 0, zOffset);
                    FluidState fluidState1 = world.getFluidState(currentPos);
                    if (fluidState1.is(FluidTags.WATER) || !((distanceSq = this.distanceToSqr(Vec3.atCenterOf((Vec3i)currentPos))) < closestDistanceSq)) continue;
                    closestDistanceSq = distanceSq;
                    closestNonLiquidBlockPos = currentPos;
                }
            }
            if (closestNonLiquidBlockPos != null) {
                Vec3 direction = Vec3.atCenterOf(closestNonLiquidBlockPos).subtract(this.position()).normalize();
                double speed = 0.5;
                Vec3 velocity = direction.scale(speed);
                this.push(0.0, 1.0, 0.0);
                this.addDeltaMovement(velocity);
            }
        }
    }
}

