/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixin.enchantment.bowleft;

import com.mafuyu33.mafishcrossbow.enchantment.ModEnchantmentHelper;
import com.mafuyu33.mafishcrossbow.enchantment.datagen.custom.ModEnchantments;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CrossbowItem.class})
public class CrossbowItemMixin {
    @Inject(method={"shootProjectile"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/Projectile;shoot(DDDFF)V", shift=At.Shift.AFTER)})
    private void applyBowLeftRight(LivingEntity shooter, Projectile projectile, int index, float velocity, float inaccuracy, float angle, @Nullable LivingEntity target, CallbackInfo ci) {
        ItemStack weapon = shooter.getUseItem();
        if (weapon.isEmpty() && !((weapon = shooter.getMainHandItem()).getItem() instanceof CrossbowItem)) {
            weapon = shooter.getOffhandItem();
        }
        if (!weapon.isEmpty()) {
            int bowLeftLevel = ModEnchantmentHelper.getEnchantmentLevel(ModEnchantments.BOWLEFT, weapon);
            int bowRightLevel = ModEnchantmentHelper.getEnchantmentLevel(ModEnchantments.BOWRIGHT, weapon);
            if (bowLeftLevel > 0 && bowRightLevel == 0) {
                Vec3 motion = projectile.getDeltaMovement();
                Vec3 rotatedMotion = this.rotateYaw(motion, -15.0f);
                projectile.setDeltaMovement(rotatedMotion);
            } else if (bowRightLevel > 0 && bowLeftLevel == 0) {
                Vec3 motion = projectile.getDeltaMovement();
                Vec3 rotatedMotion = this.rotateYaw(motion, 15.0f);
                projectile.setDeltaMovement(rotatedMotion);
            }
        }
    }

    private Vec3 rotateYaw(Vec3 vec, float degrees) {
        float radians = (float)Math.toRadians(degrees);
        float cos = (float)Math.cos(radians);
        float sin = (float)Math.sin(radians);
        double newX = vec.x * (double)cos - vec.z * (double)sin;
        double newZ = vec.x * (double)sin + vec.z * (double)cos;
        return new Vec3(newX, vec.y, newZ);
    }
}

