/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixin.enchantment.infinitearrow;

import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.infinity.PistonTemporaryBlockHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.infinity.TemporaryBlockTracker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PistonBaseBlock.class})
public class PistonBaseBlockMixin {
    @Inject(method={"moveBlocks"}, at={@At(value="RETURN")})
    private void handleStickyPistonPull(Level level, BlockPos pistonPos, Direction direction, boolean extending, CallbackInfoReturnable<Boolean> cir) {
        if (!level.isClientSide() && !extending && ((Boolean)cir.getReturnValue()).booleanValue() && level instanceof ServerLevel) {
            int remainingTime;
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos pulledFrom = pistonPos.relative(direction, 2);
            BlockPos pulledTo = pistonPos.relative(direction);
            if (TemporaryBlockTracker.isTemporary((LevelReader)level, pulledFrom) && (remainingTime = TemporaryBlockTracker.getRemainingTime(level, pulledFrom)) > 0) {
                serverLevel.destroyBlockProgress(pulledFrom.hashCode(), pulledFrom, -1);
                PistonTemporaryBlockHelper.scheduleTransfer(serverLevel, pulledFrom, pulledTo, remainingTime, 3);
            }
        }
    }
}

