/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixin.enchantment.infinitearrow;

import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.infinity.PistonTemporaryBlockHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.infinity.TemporaryBlockTracker;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PistonMovingBlockEntity.class})
public abstract class PistonMovingBlockEntityMixin
extends BlockEntity {
    @Shadow
    private Direction direction;
    @Shadow
    private boolean extending;
    @Unique
    private boolean mafishcrossbow$processed = false;

    @Shadow
    public abstract BlockState getMovedState();

    public PistonMovingBlockEntityMixin() {
        super(null, null, null);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private static void onTick(Level level, BlockPos pos, BlockState state, PistonMovingBlockEntity blockEntity, CallbackInfo ci) {
        if (!level.isClientSide() && level instanceof ServerLevel) {
            int remainingTime;
            BlockPos sourcePos;
            ServerLevel serverLevel = (ServerLevel)level;
            PistonMovingBlockEntityMixin mixin = (PistonMovingBlockEntityMixin)blockEntity;
            if (mixin.mafishcrossbow$processed) {
                return;
            }
            mixin.mafishcrossbow$processed = true;
            Direction direction = mixin.direction;
            boolean extending = mixin.extending;
            if (extending && TemporaryBlockTracker.isTemporary((LevelReader)serverLevel, sourcePos = pos.relative(direction.getOpposite())) && (remainingTime = TemporaryBlockTracker.getRemainingTime((Level)serverLevel, sourcePos)) > 0) {
                serverLevel.destroyBlockProgress(sourcePos.hashCode(), sourcePos, -1);
                PistonTemporaryBlockHelper.scheduleTransfer(serverLevel, sourcePos, pos, remainingTime, 3);
            }
        }
    }
}

