/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixin.enchantment.infinity;

import com.mafuyu33.mafishcrossbow.datacomponents.ModDataConponents;
import com.mafuyu33.mafishcrossbow.enchantment.ModEnchantmentHelper;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ProjectileWeaponItem.class})
public abstract class ProjectileWeaponItemMixin {
    @Shadow
    protected abstract void shootProjectile(LivingEntity var1, Projectile var2, int var3, float var4, float var5, float var6, @Nullable LivingEntity var7);

    @Shadow
    protected abstract Projectile createProjectile(Level var1, LivingEntity var2, ItemStack var3, ItemStack var4, boolean var5);

    @Shadow
    protected abstract int getDurabilityUse(ItemStack var1);

    @Inject(method={"shoot"}, at={@At(value="HEAD")})
    private void init(ServerLevel level, LivingEntity shooter, InteractionHand hand, ItemStack weapon, List<ItemStack> projectileItems, float velocity, float inaccuracy, boolean isCrit, LivingEntity target, CallbackInfo ci) {
        if (!projectileItems.isEmpty() && ModEnchantmentHelper.getEnchantmentLevel((ResourceKey<Enchantment>)Enchantments.INFINITY, weapon) > 0) {
            weapon.set(ModDataConponents.LAST_SHOT_PROJECTILE, projectileItems.stream().map(ItemStack::copy).toList());
        }
    }

    @Inject(method={"shoot"}, at={@At(value="HEAD")}, cancellable=true)
    private void maf$fixMultishotDurabilityBug(ServerLevel level, LivingEntity shooter, InteractionHand hand, ItemStack weapon, List<ItemStack> projectileItems, float velocity, float inaccuracy, boolean isCrit, @Nullable LivingEntity target, CallbackInfo ci) {
        if (projectileItems.size() <= 1) {
            return;
        }
        float f = EnchantmentHelper.processProjectileSpread((ServerLevel)level, (ItemStack)weapon, (Entity)shooter, (float)0.0f);
        float f1 = projectileItems.size() == 1 ? 0.0f : 2.0f * f / (float)(projectileItems.size() - 1);
        float f2 = (float)((projectileItems.size() - 1) % 2) * f1 / 2.0f;
        float f3 = 1.0f;
        ItemStack weaponCopy = weapon.copy();
        for (int i = 0; i < projectileItems.size(); ++i) {
            ItemStack itemstack = projectileItems.get(i);
            if (itemstack.isEmpty()) continue;
            float f4 = f2 + f3 * (float)((i + 1) / 2) * f1;
            f3 = -f3;
            int j = i;
            ItemStack currentWeapon = weapon.isEmpty() ? weaponCopy : weapon;
            Projectile projectile = this.createProjectile((Level)level, shooter, currentWeapon, itemstack, isCrit);
            Consumer<Projectile> adapter = p -> this.shootProjectile(shooter, (Projectile)p, j, velocity, inaccuracy, f4, target);
            Projectile.spawnProjectile((Projectile)projectile, (ServerLevel)level, (ItemStack)itemstack, adapter);
            if (weapon.isEmpty()) continue;
            weapon.hurtAndBreak(this.getDurabilityUse(itemstack), shooter, LivingEntity.getSlotForHand((InteractionHand)hand));
        }
        ci.cancel();
    }
}

