/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixin.enchantment.intangible;

import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.intangible.IntangibleHelper;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.phys.BlockHitResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Projectile.class})
public abstract class ProjectileOnHitBlockMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectileOnHitBlockMixin.class);

    @Inject(method={"onHitBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private void mafishcrossbow$cancelBlockHitForThrowable(BlockHitResult result, CallbackInfo ci) {
        Projectile projectile = (Projectile)this;
        if (projectile instanceof ThrowableProjectile && IntangibleHelper.hasIntangible(projectile.getPersistentData())) {
            LOGGER.debug("Intangible: Cancelled block hit for throwable projectile {}", (Object)projectile.getId());
            ci.cancel();
        }
    }
}

