/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixin.enchantment.intangible;

import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.intangible.IntangibleHelper;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ThrowableProjectile.class})
public abstract class ThrowableProjectileIntangibleMixin {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThrowableProjectileIntangibleMixin.class);
    @Unique
    private boolean mafishcrossbow$intangibleLogged = false;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void mafishcrossbow$intangibleThrowableTick(CallbackInfo ci) {
        ThrowableProjectile projectile = (ThrowableProjectile)this;
        if (IntangibleHelper.hasIntangible(projectile.getPersistentData()) && !projectile.noPhysics) {
            projectile.noPhysics = true;
            if (!this.mafishcrossbow$intangibleLogged) {
                LOGGER.info("Intangible: Enabled noPhysics for throwable projectile {}", (Object)projectile.getId());
                this.mafishcrossbow$intangibleLogged = true;
            }
        }
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/ProjectileUtil;getHitResultOnMoveVector(Lnet/minecraft/world/entity/Entity;Ljava/util/function/Predicate;)Lnet/minecraft/world/phys/HitResult;"))
    private HitResult mafishcrossbow$skipCollisionDetection(Entity entity, Predicate<Entity> filter) {
        ThrowableProjectile projectile = (ThrowableProjectile)this;
        if (IntangibleHelper.hasIntangible(projectile.getPersistentData())) {
            Vec3 pos = projectile.position();
            LOGGER.debug("Intangible: Skipping collision detection for throwable projectile {}", (Object)projectile.getId());
            return BlockHitResult.miss((Vec3)pos, (Direction)projectile.getDirection(), (BlockPos)projectile.blockPosition());
        }
        return ProjectileUtil.getHitResultOnMoveVector((Entity)entity, filter);
    }
}

