/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixin.enchantment.misfire;

import com.mafuyu33.mafishcrossbow.enchantment.ModEnchantmentHelper;
import com.mafuyu33.mafishcrossbow.enchantment.datagen.custom.ModEnchantments;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void mafishcrossbow$trackMisfireHolder(CallbackInfo ci) {
        LivingEntity self = (LivingEntity)this;
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack itemStack = self.getItemBySlot(slot);
            this.checkAndUpdateItem(itemStack, self);
        }
        if (self instanceof Player) {
            Player player = (Player)self;
            Inventory inventory = player.getInventory();
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                this.checkAndUpdateItem(inventory.getItem(i), self);
            }
        }
    }

    private void checkAndUpdateItem(ItemStack itemStack, LivingEntity holder) {
        if (!itemStack.isEmpty() && ModEnchantmentHelper.getEnchantmentLevel(ModEnchantments.MISFIRE, itemStack) > 0) {
            CustomData customData = (CustomData)itemStack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            CompoundTag tag = customData.copyTag();
            tag.store("mafishcrossbow_last_holder", UUIDUtil.CODEC, (Object)holder.getUUID());
            itemStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
        }
    }
}

