/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixin.enchantment.piercing;

import com.mafuyu33.mafishcrossbow.entity.TrailEntity;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.piercing.PiercingHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.entity.projectile.windcharge.AbstractWindCharge;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Projectile.class})
public class ProjectileMixin {
    @Inject(method={"canHitEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void mafishcrossbow$checkPiercedEntity(Entity target, CallbackInfoReturnable<Boolean> cir) {
        Projectile projectile = (Projectile)this;
        if (projectile instanceof ThrownTrident) {
            if (PiercingHelper.hasPiercingTag((Entity)projectile)) {
                Entity owner = projectile.getOwner();
                if (owner != null && target.getId() == owner.getId()) {
                    cir.setReturnValue((Object)false);
                    return;
                }
                if (PiercingHelper.hasAlreadyPierced((Entity)projectile, target.getId())) {
                    cir.setReturnValue((Object)false);
                }
            }
            return;
        }
        if (projectile instanceof AbstractArrow) {
            return;
        }
        if (!PiercingHelper.hasPiercingTag((Entity)projectile)) {
            return;
        }
        if (PiercingHelper.hasAlreadyPierced((Entity)projectile, target.getId())) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"onHitEntity"}, at={@At(value="HEAD")})
    private void mafishcrossbow$recordPiercedEntity(EntityHitResult result, CallbackInfo ci) {
        Projectile projectile = (Projectile)this;
        if (projectile instanceof ThrownTrident) {
            return;
        }
        if (projectile instanceof AbstractArrow) {
            return;
        }
        if (projectile instanceof TrailEntity) {
            return;
        }
        if (!PiercingHelper.hasPiercingTag((Entity)projectile)) {
            return;
        }
        Entity target = result.getEntity();
        PiercingHelper.recordPiercedEntity((Entity)projectile, target.getId());
        if (projectile instanceof ThrowableProjectile || projectile instanceof AbstractWindCharge) {
            PiercingHelper.markEntityHit(projectile);
        }
    }

    @Inject(method={"onHitBlock"}, at={@At(value="HEAD")})
    private void mafishcrossbow$clearEntityHitFlag(BlockHitResult result, CallbackInfo ci) {
        Projectile projectile = (Projectile)this;
        if (projectile instanceof ThrowableProjectile || projectile instanceof AbstractWindCharge) {
            PiercingHelper.clearEntityHitFlag(projectile);
        }
    }
}

