/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixin.enchantment.piercing;

import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.piercing.PiercingHelper;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.phys.EntityHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ThrownTrident.class})
public abstract class ThrownTridentMixin {
    @Shadow
    private boolean dealtDamage;

    @Inject(method={"onHitEntity"}, at={@At(value="HEAD")})
    private void mafishcrossbow$onHitEntityPiercing(EntityHitResult result, CallbackInfo ci) {
        ThrownTrident trident = (ThrownTrident)this;
        Entity target = result.getEntity();
        if (!PiercingHelper.hasPiercingTag((Entity)trident)) {
            return;
        }
        if (!PiercingHelper.shouldDiscardAfterHit((Entity)trident)) {
            this.dealtDamage = false;
        }
        PiercingHelper.recordPiercedEntity((Entity)trident, target.getId());
    }

    @Inject(method={"onHitEntity"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/ThrownTrident;deflect(Lnet/minecraft/world/entity/projectile/ProjectileDeflection;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity;Z)Z")}, cancellable=true)
    private void mafishcrossbow$cancelDeflectIfPiercing(EntityHitResult result, CallbackInfo ci) {
        ThrownTrident trident = (ThrownTrident)this;
        if (PiercingHelper.hasPiercingTag((Entity)trident) && !PiercingHelper.shouldDiscardAfterHit((Entity)trident)) {
            this.dealtDamage = false;
            trident.playSound(SoundEvents.TRIDENT_HIT, 1.0f, 1.0f);
            ci.cancel();
        }
    }
}

