/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixin.enchantment.silktouch;

import com.mafuyu33.mafishcrossbow.entity.TrailEntity;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.bounce.BounceHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.silktouch.SilkTouchHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Projectile.class}, priority=900)
abstract class ProjectileMixin
extends Entity {
    public ProjectileMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"onHitBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private void mafishcrossbow$silkTouchOnHitBlock(BlockHitResult hit, CallbackInfo ci) {
        Projectile self = (Projectile)this;
        if (self instanceof AbstractArrow) {
            return;
        }
        if (self instanceof TrailEntity) {
            return;
        }
        SilkTouchHelper.SilkTouchResult result = SilkTouchHelper.onHitBlockWithResult((Entity)self, this.getPersistentData(), hit);
        switch (result) {
            case PIERCE: {
                Vec3 movement = this.getDeltaMovement();
                Vec3 hitPos = hit.getLocation();
                Vec3 newPos = hitPos.add(movement.normalize().scale(1.0));
                this.setPos(newPos);
                ci.cancel();
                break;
            }
            case STOP: {
                if (BounceHelper.bounceWithCopy((Entity)self, this.getPersistentData(), hit)) {
                    ci.cancel();
                    break;
                }
                ci.cancel();
                break;
            }
        }
    }
}

