/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixin.main.bundleshot;

import com.mafuyu33.mafishcrossbow.mixinhandler.crossbowmain.strategies.BundleProjectileStrategy;
import com.mafuyu33.mafishcrossbow.network.packet.S2C.BundleProjectileS2CPacket;
import java.util.function.Consumer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Projectile.class})
public abstract class ProjectileMixin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"spawnProjectile(Lnet/minecraft/world/entity/projectile/Projectile;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/item/ItemStack;Ljava/util/function/Consumer;)Lnet/minecraft/world/entity/projectile/Projectile;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/Projectile;applyOnProjectileSpawned(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/item/ItemStack;)V")})
    private static <T extends Projectile> void onSpawnProjectile(T projectile, ServerLevel level, ItemStack stack, Consumer<T> adapter, CallbackInfoReturnable<T> cir) {
        Projectile proj = BundleProjectileStrategy.LAST_PROJECTILE.get();
        ItemStack ammo = BundleProjectileStrategy.LAST_AMMO.get();
        ItemStack weapon = BundleProjectileStrategy.LAST_WEAPON.get();
        try {
            if (proj != null && ammo != null && !ammo.isEmpty() && weapon != null && !weapon.isEmpty()) {
                PacketDistributor.sendToPlayersTrackingEntity((Entity)proj, (CustomPacketPayload)new BundleProjectileS2CPacket(ammo, weapon, proj.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        finally {
            BundleProjectileStrategy.LAST_PROJECTILE.remove();
            BundleProjectileStrategy.LAST_AMMO.remove();
            BundleProjectileStrategy.LAST_WEAPON.remove();
        }
    }
}

