/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixin.main.shulkerboxmagazine;

import com.mafuyu33.mafishcrossbow.MafishCrossbow;
import com.mafuyu33.mafishcrossbow.datacomponents.ModDataConponents;
import com.mafuyu33.mafishcrossbow.enchantment.ModEnchantmentHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.crossbowmain.crossbowoverload.OverloadHandler;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CrossbowItem.class}, priority=1100)
public abstract class ShulkerBoxLoadingMixin {
    @Inject(method={"tryLoadProjectiles"}, at={@At(value="HEAD")}, cancellable=true)
    private static void maf$tryLoadProjectilesFromShulkerBox(LivingEntity shooter, ItemStack crossbowStack, CallbackInfoReturnable<Boolean> cir) {
        BlockItem blockItem;
        Item item2;
        if (CrossbowItem.isCharged((ItemStack)crossbowStack)) {
            return;
        }
        if (!(shooter instanceof Player)) {
            return;
        }
        Player player = (Player)shooter;
        ItemStack offhand = player.getOffhandItem();
        if (offhand.isEmpty() || !((item2 = offhand.getItem()) instanceof BlockItem) || !((blockItem = (BlockItem)item2).getBlock() instanceof ShulkerBoxBlock)) {
            return;
        }
        ItemContainerContents container = (ItemContainerContents)offhand.get(DataComponents.CONTAINER);
        if (container == null) {
            cir.setReturnValue((Object)false);
            return;
        }
        ArrayList items = new ArrayList();
        container.stream().forEach(items::add);
        if (items.isEmpty()) {
            cir.setReturnValue((Object)false);
            return;
        }
        boolean hasNonEnchantedBook = items.stream().anyMatch(item -> !item.isEmpty() && item.getItem() != Items.ENCHANTED_BOOK);
        if (!hasNonEnchantedBook) {
            cir.setReturnValue((Object)false);
            return;
        }
        int multishot = ModEnchantmentHelper.getEnchantmentLevel((ResourceKey<Enchantment>)Enchantments.MULTISHOT, crossbowStack);
        int shotCount = 1 + multishot * 2;
        boolean hasInfinity = ModEnchantmentHelper.getEnchantmentLevel((ResourceKey<Enchantment>)Enchantments.INFINITY, crossbowStack) > 0;
        boolean isCreative = player.isCreative();
        int currentIndex = (Integer)crossbowStack.getOrDefault(ModDataConponents.SHULKER_BOX_INDEX.get(), (Object)0);
        MafishCrossbow.LOGGER.info("[ShulkerBoxLoading] \u5f00\u59cb\u88c5\u586b\uff0c\u5f53\u524d\u7d22\u5f15: " + currentIndex + ", \u6f5c\u5f71\u76d2\u7269\u54c1\u6570: " + items.size());
        ArrayList<ItemStack> projectilesToLoad = new ArrayList<ItemStack>();
        ArrayList<ItemEnchantments> projectileEnchantments = new ArrayList<ItemEnchantments>();
        HashMap<Holder, Integer> accumulatedEnchantments = new HashMap<Holder, Integer>();
        if (hasInfinity || isCreative) {
            int idx = currentIndex;
            int scannedItems = 0;
            ItemStack foundProjectile = null;
            ItemEnchantments foundEnchantments = null;
            while (foundProjectile == null && scannedItems < items.size()) {
                ItemStack item3 = (ItemStack)items.get(idx % items.size());
                ++scannedItems;
                if (item3.isEmpty()) {
                    ++idx;
                    continue;
                }
                if (item3.getItem() == Items.ENCHANTED_BOOK) {
                    ItemEnchantments bookEnchantments = (ItemEnchantments)item3.get(DataComponents.STORED_ENCHANTMENTS);
                    if (bookEnchantments != null) {
                        bookEnchantments.entrySet().forEach(entry -> {
                            int oldLevel = accumulatedEnchantments.getOrDefault(entry.getKey(), 0);
                            int newLevel = oldLevel + entry.getValue();
                            accumulatedEnchantments.merge((Holder)entry.getKey(), entry.getValue(), Integer::sum);
                        });
                    }
                    ++idx;
                    continue;
                }
                foundProjectile = item3.copy();
                foundProjectile.setCount(1);
                ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
                accumulatedEnchantments.forEach((arg_0, arg_1) -> ((ItemEnchantments.Mutable)mutable).set(arg_0, arg_1));
                foundEnchantments = mutable.toImmutable();
                ++idx;
            }
            if (foundProjectile != null) {
                for (int i = 0; i < shotCount; ++i) {
                    projectilesToLoad.add(foundProjectile.copy());
                    projectileEnchantments.add(foundEnchantments);
                }
            }
            crossbowStack.set(ModDataConponents.SHULKER_BOX_INDEX.get(), (Object)idx);
        } else {
            ArrayList<ItemStack> mutableItems = new ArrayList<ItemStack>();
            for (ItemStack item4 : items) {
                mutableItems.add(item4.copy());
            }
            int idx = currentIndex;
            int scannedItems = 0;
            ItemStack foundProjectile = null;
            ItemEnchantments foundEnchantments = null;
            while (foundProjectile == null && scannedItems < items.size()) {
                ItemStack item5 = (ItemStack)mutableItems.get(idx % mutableItems.size());
                ++scannedItems;
                if (item5.isEmpty()) {
                    ++idx;
                    continue;
                }
                if (item5.getItem() == Items.ENCHANTED_BOOK) {
                    ItemEnchantments bookEnchantments = (ItemEnchantments)item5.get(DataComponents.STORED_ENCHANTMENTS);
                    if (bookEnchantments != null) {
                        bookEnchantments.entrySet().forEach(entry -> {
                            int oldLevel = accumulatedEnchantments.getOrDefault(entry.getKey(), 0);
                            int newLevel = oldLevel + entry.getValue();
                            accumulatedEnchantments.merge((Holder)entry.getKey(), entry.getValue(), Integer::sum);
                        });
                    }
                    ++idx;
                    continue;
                }
                foundProjectile = item5.copy();
                foundProjectile.setCount(1);
                ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
                accumulatedEnchantments.forEach((arg_0, arg_1) -> ((ItemEnchantments.Mutable)mutable).set(arg_0, arg_1));
                foundEnchantments = mutable.toImmutable();
                MafishCrossbow.LOGGER.info("  [DEBUG] \u627e\u5230\u6295\u5c04\u7269 " + String.valueOf(item5.getItem()) + "\uff0c\u7d22\u5f15 " + (idx - 1) % items.size() + "\uff0c\u5e94\u7528\u7d2f\u79ef\u9644\u9b54\uff0c\u9644\u9b54\u6570\u91cf: " + accumulatedEnchantments.size());
                ++idx;
                break;
            }
            if (foundProjectile != null) {
                int foundIndex = (idx - 1) % mutableItems.size();
                if (foundIndex < 0) {
                    foundIndex += mutableItems.size();
                }
                ItemStack itemToConsume = (ItemStack)mutableItems.get(foundIndex);
                int toConsume = Math.min(shotCount, itemToConsume.getCount());
                for (int i = 0; i < toConsume; ++i) {
                    projectilesToLoad.add(foundProjectile.copy());
                    projectileEnchantments.add(foundEnchantments);
                }
                itemToConsume.shrink(toConsume);
                ArrayList<ItemStack> finalItems = new ArrayList<ItemStack>();
                for (ItemStack item6 : mutableItems) {
                    finalItems.add(item6);
                }
                offhand.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(finalItems));
            }
            if (projectilesToLoad.isEmpty()) {
                cir.setReturnValue((Object)false);
                return;
            }
            MafishCrossbow.LOGGER.info("[ShulkerBoxLoading] \u66f4\u65b0\u7d22\u5f15\u4ece " + currentIndex + " \u5230 " + idx);
            crossbowStack.set(ModDataConponents.SHULKER_BOX_INDEX.get(), (Object)idx);
        }
        if (OverloadHandler.mafishcrossbow$isItemStackOversized(projectilesToLoad, shooter)) {
            OverloadHandler.mafishcrossbow$addBlackHoleInstead(shooter, crossbowStack, (ItemStack)projectilesToLoad.get(0));
            cir.setReturnValue((Object)true);
            return;
        }
        crossbowStack.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of(projectilesToLoad));
        crossbowStack.set(ModDataConponents.PROJECTILE_ENCHANTMENTS.get(), projectileEnchantments);
        crossbowStack.set(ModDataConponents.CURRENT_PROJECTILE_INDEX.get(), (Object)0);
        cir.setReturnValue((Object)true);
    }
}

