/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixin.main.shulkerboxmagazine;

import com.mafuyu33.mafishcrossbow.datacomponents.ModDataConponents;
import com.mafuyu33.mafishcrossbow.enchantment.ModEnchantmentHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CrossbowItem.class})
public abstract class ShulkerBoxShootingMixin {
    @Inject(method={"performShooting"}, at={@At(value="HEAD")})
    private void maf$applyTempEnchantmentsBeforeShooting(Level level, LivingEntity shooter, InteractionHand hand, ItemStack crossbow, float velocity, float inaccuracy, @Nullable LivingEntity target, CallbackInfo ci) {
        if (level.isClientSide) {
            return;
        }
        List projectileEnchantments = (List)crossbow.get(ModDataConponents.PROJECTILE_ENCHANTMENTS.get());
        if (projectileEnchantments == null || projectileEnchantments.isEmpty()) {
            return;
        }
        int currentIndex = (Integer)crossbow.getOrDefault(ModDataConponents.CURRENT_PROJECTILE_INDEX.get(), (Object)0);
        if (currentIndex >= projectileEnchantments.size()) {
            return;
        }
        ItemEnchantments enchantmentsToApply = (ItemEnchantments)projectileEnchantments.get(currentIndex);
        if (enchantmentsToApply == null || enchantmentsToApply.isEmpty()) {
            return;
        }
        ItemEnchantments originalEnchantments = (ItemEnchantments)crossbow.get(DataComponents.ENCHANTMENTS);
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(originalEnchantments);
        enchantmentsToApply.entrySet().forEach(entry -> {
            int currentLevel = mutable.getLevel((Holder)entry.getKey());
            mutable.set((Holder)entry.getKey(), currentLevel + entry.getValue());
        });
        crossbow.set(DataComponents.ENCHANTMENTS, (Object)mutable.toImmutable());
        crossbow.set(ModDataConponents.ORIGINAL_ENCHANTMENTS.get(), (Object)originalEnchantments);
    }

    @Inject(method={"performShooting"}, at={@At(value="RETURN")})
    private void maf$restoreEnchantmentsAfterShooting(Level level, LivingEntity shooter, InteractionHand hand, ItemStack crossbow, float velocity, float inaccuracy, @Nullable LivingEntity target, CallbackInfo ci) {
        List projectileEnchantments;
        Player player;
        boolean isCreative;
        if (level.isClientSide) {
            return;
        }
        ItemEnchantments originalEnchantments = (ItemEnchantments)crossbow.get(ModDataConponents.ORIGINAL_ENCHANTMENTS.get());
        if (originalEnchantments != null) {
            crossbow.set(DataComponents.ENCHANTMENTS, (Object)originalEnchantments);
            crossbow.remove(ModDataConponents.ORIGINAL_ENCHANTMENTS.get());
        }
        boolean hasInfinity = ModEnchantmentHelper.getEnchantmentLevel((ResourceKey<Enchantment>)Enchantments.INFINITY, crossbow) > 0;
        boolean bl = isCreative = shooter instanceof Player && (player = (Player)shooter).isCreative();
        if (hasInfinity || isCreative) {
            ChargedProjectiles chargedProjectiles = (ChargedProjectiles)crossbow.get(DataComponents.CHARGED_PROJECTILES);
            List enchantmentsList = (List)crossbow.get(ModDataConponents.PROJECTILE_ENCHANTMENTS.get());
            if (chargedProjectiles != null && !chargedProjectiles.isEmpty()) {
                int currentIndex;
                ArrayList projectiles = new ArrayList();
                chargedProjectiles.getItems().forEach(projectiles::add);
                crossbow.set(ModDataConponents.LAST_SHOT_PROJECTILE.get(), projectiles);
                if (enchantmentsList != null && !enchantmentsList.isEmpty() && (currentIndex = ((Integer)crossbow.getOrDefault(ModDataConponents.CURRENT_PROJECTILE_INDEX.get(), (Object)0)).intValue()) < enchantmentsList.size()) {
                    ArrayList<ItemEnchantments> currentEnchantments = new ArrayList<ItemEnchantments>();
                    currentEnchantments.add((ItemEnchantments)enchantmentsList.get(currentIndex));
                    crossbow.set(ModDataConponents.LAST_SHOT_ENCHANTMENTS.get(), currentEnchantments);
                }
            }
        }
        if ((projectileEnchantments = (List)crossbow.get(ModDataConponents.PROJECTILE_ENCHANTMENTS.get())) != null && !projectileEnchantments.isEmpty()) {
            int currentIndex = (Integer)crossbow.getOrDefault(ModDataConponents.CURRENT_PROJECTILE_INDEX.get(), (Object)0);
            if (++currentIndex >= projectileEnchantments.size()) {
                if (!hasInfinity) {
                    crossbow.remove(ModDataConponents.PROJECTILE_ENCHANTMENTS.get());
                    crossbow.remove(ModDataConponents.CURRENT_PROJECTILE_INDEX.get());
                } else {
                    crossbow.set(ModDataConponents.CURRENT_PROJECTILE_INDEX.get(), (Object)0);
                }
            } else {
                crossbow.set(ModDataConponents.CURRENT_PROJECTILE_INDEX.get(), (Object)currentIndex);
            }
        }
    }
}

