/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.crossbowmain.strategies;

import com.mafuyu33.mafishcrossbow.api.CrossbowProjectileStrategy;
import com.mafuyu33.mafishcrossbow.api.ShooterContext;
import com.mafuyu33.mafishcrossbow.entity.custom.BlackholeProjectile;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.ModifierManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StructureVoidBlock;
import net.minecraft.world.phys.Vec3;

public class BlockHoleStrategy
implements CrossbowProjectileStrategy {
    @Override
    public Projectile tryHandle(Level level, ShooterContext context, ItemStack weapon, ItemStack ammo) {
        Block block = Block.byItem((Item)ammo.getItem());
        if (!(block instanceof StructureVoidBlock)) {
            return null;
        }
        BlackholeProjectile blackhole = new BlackholeProjectile(level, context.getShooter(), weapon);
        blackhole.setOwner((Entity)context.getShooter());
        Vec3 look = context.getLookDirection();
        Vec3 pos = context.getPosition().add(look.normalize().scale(2.0));
        blackhole.setPos(pos.x, pos.y, pos.z);
        ModifierManager.applyTagModifier((Entity)blackhole, weapon, ammo, context);
        return blackhole;
    }
}

