/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.crossbowmain.strategies;

import com.mafuyu33.mafishcrossbow.api.CrossbowProjectileStrategy;
import com.mafuyu33.mafishcrossbow.api.ShooterContext;
import com.mafuyu33.mafishcrossbow.entity.custom.BundleProjectile;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.ModifierManager;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class BundleProjectileStrategy
implements CrossbowProjectileStrategy {
    public static final ThreadLocal<Projectile> LAST_PROJECTILE = new ThreadLocal();
    public static final ThreadLocal<ItemStack> LAST_AMMO = new ThreadLocal();
    public static final ThreadLocal<ItemStack> LAST_WEAPON = new ThreadLocal();

    @Override
    public Projectile tryHandle(Level level, ShooterContext context, ItemStack weapon, ItemStack ammo) {
        if (ammo.getItem() instanceof BundleItem && !level.isClientSide()) {
            BundleProjectile proj = BundleProjectile.create(level, context.getShooter(), ammo, weapon);
            LAST_PROJECTILE.set((Projectile)proj);
            LAST_AMMO.set(ammo.copy());
            LAST_WEAPON.set(weapon.copy());
            proj.setOwner((Entity)context.getShooter());
            ModifierManager.applyTagModifier((Entity)proj, weapon, ammo, context);
            return proj;
        }
        return null;
    }
}

