/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.crossbowmain.strategies;

import com.mafuyu33.mafishcrossbow.api.CrossbowProjectileStrategy;
import com.mafuyu33.mafishcrossbow.api.ShooterContext;
import com.mafuyu33.mafishcrossbow.entity.ModEntities;
import com.mafuyu33.mafishcrossbow.entity.custom.EntityProjectileShell;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.ModifierManager;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class MinecartItemProjectileStrategy
implements CrossbowProjectileStrategy {
    @Override
    public Projectile tryHandle(Level level, ShooterContext context, ItemStack weapon, ItemStack ammo) {
        Item item = ammo.getItem();
        if (item instanceof MinecartItem) {
            MinecartItem minecartItem = (MinecartItem)item;
            AbstractMinecart minecart = (AbstractMinecart)minecartItem.type.create(level, EntitySpawnReason.SPAWN_ITEM_USE);
            if (minecart != null) {
                Vec3 look = context.getLookDirection();
                Vec3 normalizedLook = look.normalize();
                Vec3 pos = context.getPosition().add(normalizedLook.scale(2.0));
                minecart.setPos(pos.x, pos.y, pos.z);
                minecart.setDeltaMovement(normalizedLook.scale(1.5));
                float yaw = context.getShooter() != null ? context.getShooter().getYRot() : 0.0f;
                minecart.setYRot(Mth.wrapDegrees((float)(yaw - 90.0f)));
                minecart.setYBodyRot(yaw);
                minecart.setYHeadRot(yaw);
                ModifierManager.applyTagModifier((Entity)minecart, weapon, ammo, context);
                EntityProjectileShell<AbstractMinecart> shell = new EntityProjectileShell<AbstractMinecart>((EntityType)ModEntities.PROJECTILE_SHELL.get(), level, minecart);
                shell.setOwner((Entity)context.getShooter());
                shell.setPos(pos);
                shell.setDeltaMovement(normalizedLook.scale(1.5));
                return shell;
            }
        }
        return null;
    }
}

