/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.crossbowmain.strategies;

import com.mafuyu33.mafishcrossbow.MafishCrossbow;
import com.mafuyu33.mafishcrossbow.api.CrossbowProjectileStrategy;
import com.mafuyu33.mafishcrossbow.api.ShooterContext;
import com.mafuyu33.mafishcrossbow.api.ThrowableFactory;
import com.mafuyu33.mafishcrossbow.entity.custom.CustomLlamaSpitEntity;
import com.mafuyu33.mafishcrossbow.mixinhandler.crossbowmain.livingentityadapt.StaticShooterContext;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.ModifierManager;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.DragonFireball;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayerFactory;

public class ThrowableItemProjectileStrategy
implements CrossbowProjectileStrategy {
    private static final Map<Item, ThrowableFactory> THROWABLES = Map.of(Items.DRAGON_BREATH, (level, shooter, ammo) -> new DragonFireball(level, shooter, new Vec3(0.0, 0.0, 0.0)), Items.GHAST_TEAR, (level, shooter, ammo) -> new CustomLlamaSpitEntity(level, shooter), Items.ENDER_PEARL, ThrownEnderpearl::new, Items.WITHER_SKELETON_SKULL, (level, shooter, ammo) -> new WitherSkull(level, shooter, new Vec3(0.0, 0.0, 0.0)));

    @Override
    public Projectile tryHandle(Level level, ShooterContext ctx, ItemStack weapon, ItemStack ammo) {
        ThrowableFactory f;
        Item item = ammo.getItem();
        LivingEntity shooter = ctx.getShooter();
        if (shooter == null && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            shooter = FakePlayerFactory.getMinecraft((ServerLevel)serverLevel);
        }
        if ((f = THROWABLES.get(item)) != null) {
            return this.init(f.create(level, shooter, ammo), ctx, weapon, ammo);
        }
        if (item instanceof ProjectileItem) {
            ProjectileItem pi = (ProjectileItem)item;
            Direction dir = shooter != null ? shooter.getDirection() : Direction.NORTH;
            Projectile projectile = pi.asProjectile(level, (Position)ctx.getPosition(), ammo, dir);
            return this.init(projectile, ctx, weapon, ammo);
        }
        if (item instanceof ArrowItem) {
            ArrowItem arrowItem = (ArrowItem)item;
            return this.init((Projectile)arrowItem.createArrow(level, ammo, shooter, weapon), ctx, weapon, ammo);
        }
        return null;
    }

    private Projectile init(Projectile p, ShooterContext ctx, ItemStack w, ItemStack a) {
        p.setDeltaMovement(ctx.getLookDirection().scale(3.0));
        p.setOwner((Entity)ctx.getShooter());
        ModifierManager.applyTagModifier((Entity)p, w, a, ctx);
        if (p instanceof ThrownEnderpearl) {
            StaticShooterContext staticCtx;
            ThrownEnderpearl enderPearl = (ThrownEnderpearl)p;
            if (ctx instanceof StaticShooterContext && (staticCtx = (StaticShooterContext)ctx).hasTurretSource()) {
                CompoundTag tag = new CompoundTag();
                tag.putBoolean("turret_fired", true);
                tag.putLong("turret_uuid_most", staticCtx.getTurretUUID().getMostSignificantBits());
                tag.putLong("turret_uuid_least", staticCtx.getTurretUUID().getLeastSignificantBits());
                tag.putString("turret_dimension", staticCtx.getTurretDimension());
                enderPearl.getPersistentData().merge(tag);
                MafishCrossbow.LOGGER.info("[Turret Ender Pearl] \u590d\u5236\u70ae\u53f0\u6807\u8bb0\u5230\u65b0\u672b\u5f71\u73cd\u73e0 - UUID: {}, \u7ef4\u5ea6: {}", (Object)staticCtx.getTurretUUID(), (Object)staticCtx.getTurretDimension());
            }
        }
        return p;
    }
}

