/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.boreburst;

import com.mafuyu33.mafishcrossbow.MafishCrossbow;
import com.mafuyu33.mafishcrossbow.entity.custom.AnyProjectile;
import com.mafuyu33.mafishcrossbow.entity.custom.BundleProjectile;
import com.mafuyu33.mafishcrossbow.entity.custom.CustomFallingBlockEntity;
import com.mafuyu33.mafishcrossbow.entity.custom.FiredCrossbowProjectile;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.infinity.InfinityHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.infinity.TemporaryBlockTracker;
import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BoreBurstHelper {
    private static final Map<Vec3, PlacementContext> sharedContexts = new ConcurrentHashMap<Vec3, PlacementContext>();
    private static final Map<Vec3, Long> contextTimestamps = new ConcurrentHashMap<Vec3, Long>();

    private static PlacementContext getSharedContext(Vec3 centerPos) {
        BlockPos blockPos = BlockPos.containing((Position)centerPos);
        Vec3 key = Vec3.atCenterOf((Vec3i)blockPos);
        long currentTime = System.currentTimeMillis();
        contextTimestamps.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() > 1000L);
        sharedContexts.keySet().removeIf(k -> !contextTimestamps.containsKey(k));
        PlacementContext context = sharedContexts.computeIfAbsent(key, k -> new PlacementContext(blockPos));
        contextTimestamps.put(key, currentTime);
        return context;
    }

    public static void update(Entity self, CompoundTag tag) {
        if (!tag.contains("mafishcrossbow_bore_burst") || self.level().isClientSide()) {
            return;
        }
        BoreBurstHelper.triggerBoreBurst(self);
        tag.remove("mafishcrossbow_bore_burst");
    }

    private static void triggerBoreBurst(Entity entity) {
        if (entity.level().isClientSide()) {
            return;
        }
        Vec3 pos = entity.position();
        Level level = entity.level();
        BlockPos blockPos = BlockPos.containing((Position)pos);
        Entity entity2 = entity;
        Objects.requireNonNull(entity2);
        Entity entity3 = entity2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CustomFallingBlockEntity.class, FiredCrossbowProjectile.class, BundleProjectile.class, AnyProjectile.class, Projectile.class}, (Object)entity3, n)) {
            case 0: {
                CustomFallingBlockEntity fallingBlock = (CustomFallingBlockEntity)entity3;
                BoreBurstHelper.handleSingleBlock(fallingBlock, pos);
                entity.discard();
                return;
            }
            case 1: {
                FiredCrossbowProjectile firedCrossbow = (FiredCrossbowProjectile)entity3;
                boolean hasInfinitySource = InfinityHelper.hasInfinitySource((Projectile)firedCrossbow);
                if (hasInfinitySource) {
                    firedCrossbow.setSourceHasInfinity(true);
                }
                BoreBurstHelper.triggerDefaultProjectileHit((Projectile)firedCrossbow, pos, blockPos);
                return;
            }
            case 2: {
                BundleProjectile bundleProjectile = (BundleProjectile)entity3;
                boolean hasInfinitySource = InfinityHelper.hasInfinitySource((Projectile)bundleProjectile);
                if (hasInfinitySource) {
                    bundleProjectile.getPersistentData().putBoolean("mafishcrossbow_bore_burst_infinity", true);
                }
                BoreBurstHelper.triggerDefaultProjectileHit((Projectile)bundleProjectile, pos, blockPos);
                return;
            }
            case 3: {
                AnyProjectile anyProjectile = (AnyProjectile)entity3;
                ItemStack carriedItem = anyProjectile.getItem();
                Item item = carriedItem.getItem();
                if (item instanceof BucketItem) {
                    BucketItem bucketItem = (BucketItem)item;
                    BoreBurstHelper.handleBucketPlacement(bucketItem, pos, level);
                    entity.discard();
                    return;
                }
                BoreBurstHelper.triggerDefaultProjectileHit((Projectile)anyProjectile, pos, blockPos);
                return;
            }
            case 4: {
                Projectile projectile = (Projectile)entity3;
                try {
                    Method onHitMethod = null;
                    for (Class<?> currentClass = projectile.getClass(); currentClass != null && Projectile.class.isAssignableFrom(currentClass); currentClass = currentClass.getSuperclass()) {
                        try {
                            onHitMethod = currentClass.getDeclaredMethod("onHit", HitResult.class);
                            break;
                        }
                        catch (NoSuchMethodException e) {
                            continue;
                        }
                    }
                    if (onHitMethod != null) {
                        onHitMethod.setAccessible(true);
                        EntityHitResult entityHit = new EntityHitResult((Entity)projectile);
                        onHitMethod.invoke((Object)projectile, entityHit);
                    } else {
                        BlockHitResult hitResult = new BlockHitResult(pos, Direction.UP, blockPos.below(), false);
                        Method onHitBlockMethod = Projectile.class.getDeclaredMethod("onHitBlock", BlockHitResult.class);
                        onHitBlockMethod.setAccessible(true);
                        onHitBlockMethod.invoke((Object)projectile, hitResult);
                    }
                    entity.discard();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    entity.discard();
                }
                return;
            }
        }
    }

    private static void triggerDefaultProjectileHit(Projectile projectile, Vec3 pos, BlockPos blockPos) {
        try {
            Method onHitMethod = null;
            for (Class<?> currentClass = projectile.getClass(); currentClass != null && Projectile.class.isAssignableFrom(currentClass); currentClass = currentClass.getSuperclass()) {
                try {
                    onHitMethod = currentClass.getDeclaredMethod("onHit", HitResult.class);
                    break;
                }
                catch (NoSuchMethodException e) {
                    continue;
                }
            }
            if (onHitMethod != null) {
                onHitMethod.setAccessible(true);
                EntityHitResult entityHit = new EntityHitResult((Entity)projectile);
                onHitMethod.invoke((Object)projectile, entityHit);
            } else {
                BlockHitResult hitResult = new BlockHitResult(pos, Direction.UP, blockPos.below(), false);
                Method onHitBlockMethod = Projectile.class.getDeclaredMethod("onHitBlock", BlockHitResult.class);
                onHitBlockMethod.setAccessible(true);
                onHitBlockMethod.invoke((Object)projectile, hitResult);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        projectile.discard();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleBucketPlacement(BucketItem bucketItem, Vec3 pos, Level level) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockState liquidState = null;
        if (bucketItem == Items.WATER_BUCKET) {
            liquidState = Blocks.WATER.defaultBlockState();
        } else if (bucketItem == Items.LAVA_BUCKET) {
            liquidState = Blocks.LAVA.defaultBlockState();
        } else if (bucketItem == Items.POWDER_SNOW_BUCKET) {
            liquidState = Blocks.POWDER_SNOW.defaultBlockState();
        }
        if (liquidState != null) {
            PlacementContext context;
            PlacementContext placementContext = context = BoreBurstHelper.getSharedContext(pos);
            synchronized (placementContext) {
                BlockPos placePos = BoreBurstHelper.findOptimalLiquidPosition(context, serverLevel, liquidState);
                if (placePos != null) {
                    context.occupiedPositions.add(placePos);
                    serverLevel.setBlock(placePos, liquidState, 3);
                    context.lastSuccessPos = placePos;
                    serverLevel.playSound(null, placePos, bucketItem == Items.LAVA_BUCKET ? SoundEvents.BUCKET_EMPTY_LAVA : SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
                } else {
                    MafishCrossbow.LOGGER.debug("Could not find suitable position for liquid placement at {}", (Object)pos);
                }
            }
        }
    }

    private static BlockPos findOptimalLiquidPosition(PlacementContext context, ServerLevel level, BlockState liquidState) {
        BlockPos center = context.lastSuccessPos;
        if (BoreBurstHelper.canPlaceLiquidAt((Level)level, center) && !context.occupiedPositions.contains(center)) {
            return center;
        }
        for (int dy = 1; dy <= 8; ++dy) {
            BlockPos below = center.below(dy);
            if (!BoreBurstHelper.canPlaceLiquidAt((Level)level, below) || context.occupiedPositions.contains(below)) continue;
            return below;
        }
        return BoreBurstHelper.searchSphericalForLiquid(context, level);
    }

    private static BlockPos searchSphericalForLiquid(PlacementContext context, ServerLevel level) {
        BlockPos center = context.lastSuccessPos;
        for (int radius = 1; radius <= 32; ++radius) {
            ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dy = -radius; dy <= radius; ++dy) {
                    for (int dz = -radius; dz <= radius; ++dz) {
                        BlockPos testPos;
                        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                        if (!(distance >= (double)(radius - 1)) || !(distance <= (double)radius) || !BoreBurstHelper.canPlaceLiquidAt((Level)level, testPos = center.offset(dx, dy, dz)) || context.occupiedPositions.contains(testPos)) continue;
                        candidates.add(testPos);
                    }
                }
            }
            if (candidates.isEmpty()) continue;
            return candidates.stream().min(Comparator.comparingInt(Vec3i::getY)).orElse((BlockPos)candidates.get(0));
        }
        return null;
    }

    private static boolean canPlaceLiquidAt(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (state.isAir()) {
            return true;
        }
        if (state.canBeReplaced()) {
            return true;
        }
        Block block = state.getBlock();
        if (block instanceof LiquidBlockContainer) {
            LiquidBlockContainer container = (LiquidBlockContainer)block;
            return container.canPlaceLiquid(null, (BlockGetter)level, pos, state, (Fluid)Fluids.WATER);
        }
        return false;
    }

    private static void handleSingleBlock(CustomFallingBlockEntity entity, Vec3 pos) {
        Level level = entity.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ArrayList<BlockState> blocks = new ArrayList<BlockState>();
        blocks.add(entity.getBlockState());
        boolean hasInfinitySource = InfinityHelper.hasInfinitySource(entity);
        BoreBurstHelper.handleMultipleBlocks(blocks, pos, serverLevel, entity.dropItem, hasInfinitySource);
    }

    public static void handleMultipleBlocks(List<BlockState> blocks, Vec3 centerPos, ServerLevel level, boolean dropItem) {
        BoreBurstHelper.handleMultipleBlocks(blocks, centerPos, level, dropItem, false);
    }

    public static void handleMultipleBlocks(List<BlockState> blocks, Vec3 centerPos, ServerLevel level, boolean dropItem, boolean hasInfinitySource) {
        if (blocks == null || blocks.isEmpty()) {
            return;
        }
        PlacementContext context = new PlacementContext(BlockPos.containing((Position)centerPos));
        for (BlockState state : blocks) {
            BlockPos placePos = BoreBurstHelper.findOptimalPosition(context, level, state);
            if (placePos != null) {
                if (!BoreBurstHelper.tryPlaceBlock(level, placePos, state)) continue;
                context.lastSuccessPos = placePos;
                context.occupiedPositions.add(placePos);
                if (!hasInfinitySource) continue;
                int temporaryLifetime = 400;
                TemporaryBlockTracker.markTemporary((Level)level, placePos, temporaryLifetime);
                continue;
            }
            if (!dropItem || !level.getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS) || hasInfinitySource) continue;
            Block.popResource((Level)level, (BlockPos)BlockPos.containing((Position)centerPos), (ItemStack)new ItemStack((ItemLike)state.getBlock()));
        }
    }

    private static BlockPos findOptimalPosition(PlacementContext context, ServerLevel level, BlockState state) {
        BlockPos nearbyPos = BoreBurstHelper.searchNearbyPositions(context, level);
        if (nearbyPos != null) {
            return nearbyPos;
        }
        return BoreBurstHelper.searchSpherical(context, level);
    }

    private static BlockPos searchNearbyPositions(PlacementContext context, ServerLevel level) {
        Direction[] directions;
        BlockPos lastPos = context.lastSuccessPos;
        for (Direction dir : directions = new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST}) {
            BlockPos testPos = lastPos.relative(dir);
            if (context.occupiedPositions.contains(testPos) || !BoreBurstHelper.canPlaceAt(level, testPos)) continue;
            return testPos;
        }
        return null;
    }

    private static BlockPos searchSpherical(PlacementContext context, ServerLevel level) {
        BlockPos center = context.lastSuccessPos;
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        for (int radius = 1; radius <= context.maxRadius; ++radius) {
            candidates.clear();
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dy = -radius; dy <= radius; ++dy) {
                    for (int dz = -radius; dz <= radius; ++dz) {
                        BlockPos testPos;
                        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
                        if (!(distance >= (double)(radius - 1)) || !(distance <= (double)radius) || context.occupiedPositions.contains(testPos = center.offset(dx, dy, dz)) || !BoreBurstHelper.canPlaceAt(level, testPos)) continue;
                        candidates.add(testPos);
                    }
                }
            }
            if (candidates.isEmpty()) continue;
            return BoreBurstHelper.selectBestCandidate(candidates, center, context);
        }
        return null;
    }

    private static BlockPos selectBestCandidate(List<BlockPos> candidates, BlockPos center, PlacementContext context) {
        return candidates.stream().min(Comparator.comparingInt(pos -> pos.getY()).thenComparingInt(pos -> BoreBurstHelper.calculateAdjacentScore(pos, context)).thenComparingDouble(pos -> pos.distSqr((Vec3i)center))).orElse(candidates.get(0));
    }

    private static int calculateAdjacentScore(BlockPos pos, PlacementContext context) {
        int adjacentCount = 0;
        for (Direction dir : Direction.values()) {
            if (!context.occupiedPositions.contains(pos.relative(dir))) continue;
            ++adjacentCount;
        }
        return -adjacentCount;
    }

    private static boolean canPlaceAt(ServerLevel level, BlockPos pos) {
        BlockState existingState = level.getBlockState(pos);
        return existingState.isAir() || existingState.canBeReplaced();
    }

    private static boolean tryPlaceBlock(ServerLevel level, BlockPos pos, BlockState state) {
        BlockState existingState = level.getBlockState(pos);
        if (existingState.isAir() || existingState.canBeReplaced()) {
            level.setBlock(pos, state, 19);
            SoundType soundType = state.getSoundType();
            level.playSound(null, pos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
            return true;
        }
        return false;
    }

    private static class PlacementContext {
        volatile BlockPos lastSuccessPos;
        Set<BlockPos> occupiedPositions;
        Queue<BlockPos> searchQueue;
        int maxRadius;

        PlacementContext(BlockPos center) {
            this.lastSuccessPos = center;
            this.occupiedPositions = Collections.synchronizedSet(new HashSet());
            this.searchQueue = new LinkedList<BlockPos>();
            this.maxRadius = 32;
        }
    }
}

