/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.bowright;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.Vec3;

public class BowRightHelper {
    public static boolean hasBowRight(CompoundTag tag) {
        return tag.contains("mafishcrossbow_bowright") && tag.getIntOr("mafishcrossbow_bowright", 0) > 0;
    }

    public static int getBowRightLevel(CompoundTag tag) {
        return tag.getIntOr("mafishcrossbow_bowright", 0);
    }

    public static void applyBowRight(Entity entity) {
        if (!entity.level().isClientSide && BowRightHelper.hasBowRight(entity.getPersistentData()) && entity instanceof Projectile) {
            Projectile projectile = (Projectile)entity;
            Vec3 motion = projectile.getDeltaMovement();
            float yawOffset = 0.5f;
            Vec3 rotatedMotion = BowRightHelper.rotateYaw(motion, yawOffset);
            projectile.setDeltaMovement(rotatedMotion);
        }
    }

    private static Vec3 rotateYaw(Vec3 vec, float degrees) {
        float radians = (float)Math.toRadians(degrees);
        float cos = (float)Math.cos(radians);
        float sin = (float)Math.sin(radians);
        double newX = vec.x * (double)cos - vec.z * (double)sin;
        double newZ = vec.x * (double)sin + vec.z * (double)cos;
        return new Vec3(newX, vec.y, newZ);
    }
}

