/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.frostwalker;

import com.mafuyu33.mafishcrossbow.block.CustomFrostedIceBlock;
import com.mafuyu33.mafishcrossbow.block.ModBlocks;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class FrostWalkerHelper {
    private static final String LAST_POS_X = "mafishcrossbow_frostwalker_lastX";
    private static final String LAST_POS_Y = "mafishcrossbow_frostwalker_lastY";
    private static final String LAST_POS_Z = "mafishcrossbow_frostwalker_lastZ";
    private static final String TICK_COUNTER = "mafishcrossbow_frostwalker_tick";
    private static final String DELAYED_POSITIONS = "mafishcrossbow_frostwalker_delayed";
    private static final String WAS_MOVING = "mafishcrossbow_frostwalker_wasMoving";
    private static final double STOPPED_THRESHOLD = 0.01;

    public static void onEntityRemoved(Entity entity, CompoundTag tag) {
        if (!tag.contains("mafishcrossbow_frostwalker") || entity.level().isClientSide()) {
            return;
        }
        Level level = entity.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ListTag delayedList = tag.contains(DELAYED_POSITIONS) ? (ListTag)tag.get(DELAYED_POSITIONS) : new ListTag();
        for (Tag t : delayedList) {
            if (!(t instanceof CompoundTag)) continue;
            CompoundTag posTag = (CompoundTag)t;
            int x = posTag.getIntOr("x", 0);
            int y = posTag.getIntOr("y", 0);
            int z = posTag.getIntOr("z", 0);
            int level_val = posTag.getIntOr("level", 1);
            BlockPos pos = new BlockPos(x, y, z);
            int radius = level_val - 1;
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos offsetPos = pos.offset(dx, 0, dz);
                    FrostWalkerHelper.placeIce(serverLevel, offsetPos, level_val);
                }
            }
        }
    }

    public static void update(Entity entity, CompoundTag tag) {
        boolean isVehicle;
        if (!tag.contains("mafishcrossbow_frostwalker") || entity.level().isClientSide()) {
            return;
        }
        int lvl = tag.getIntOr("mafishcrossbow_frostwalker", -1);
        if (lvl <= 0) {
            return;
        }
        Level level = entity.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int tickCounter = tag.getIntOr(TICK_COUNTER, 0);
        tag.putInt(TICK_COUNTER, ++tickCounter);
        Vec3 currentPos = entity.position();
        Vec3 velocity = entity.getDeltaMovement();
        double speed = velocity.length();
        ListTag delayedList = tag.contains(DELAYED_POSITIONS) ? (ListTag)tag.get(DELAYED_POSITIONS) : new ListTag();
        boolean bl = isVehicle = entity instanceof Boat || entity instanceof AbstractMinecart;
        if (isVehicle) {
            if (tickCounter % 2 != 0) {
                tag.putDouble(LAST_POS_X, currentPos.x);
                tag.putDouble(LAST_POS_Y, currentPos.y);
                tag.putDouble(LAST_POS_Z, currentPos.z);
                return;
            }
            if (tag.contains(LAST_POS_X)) {
                double lastX = tag.getDoubleOr(LAST_POS_X, currentPos.x);
                double lastY = tag.getDoubleOr(LAST_POS_Y, currentPos.y);
                double lastZ = tag.getDoubleOr(LAST_POS_Z, currentPos.z);
                Vec3 lastPos = new Vec3(lastX, lastY, lastZ);
                double distance = currentPos.distanceTo(lastPos);
                double spacing = lvl == 1 ? 0.5 : 0.3;
                int steps = Math.max(1, (int)Math.ceil(distance / spacing));
                HashSet<BlockPos> recordedPositions = new HashSet<BlockPos>();
                for (int i = 0; i <= steps; ++i) {
                    double t = steps > 0 ? (double)i / (double)steps : 0.0;
                    Vec3 interpolatedPos = lastPos.lerp(currentPos, t);
                    BlockPos icePos = BlockPos.containing((Position)interpolatedPos).below();
                    if (recordedPositions.contains(icePos)) continue;
                    recordedPositions.add(icePos);
                    int radius = lvl - 1;
                    for (int dx = -radius; dx <= radius; ++dx) {
                        for (int dz = -radius; dz <= radius; ++dz) {
                            BlockPos offsetPos = icePos.offset(dx, 0, dz);
                            FrostWalkerHelper.placeIce(serverLevel, offsetPos, lvl);
                        }
                    }
                }
            }
            tag.putDouble(LAST_POS_X, currentPos.x);
            tag.putDouble(LAST_POS_Y, currentPos.y);
            tag.putDouble(LAST_POS_Z, currentPos.z);
            return;
        }
        if (entity instanceof AbstractArrow) {
            boolean isMoving;
            boolean wasMoving = tag.getBooleanOr(WAS_MOVING, true);
            boolean bl2 = isMoving = speed > 0.01;
            if (wasMoving && !isMoving && !delayedList.isEmpty()) {
                FrostWalkerHelper.generateAllDelayedIce(serverLevel, delayedList, lvl);
                delayedList = new ListTag();
                tag.put(DELAYED_POSITIONS, (Tag)delayedList);
                tag.putBoolean(WAS_MOVING, false);
                return;
            }
            tag.putBoolean(WAS_MOVING, isMoving);
        }
        if (tag.contains(LAST_POS_X)) {
            double lastX = tag.getDoubleOr(LAST_POS_X, currentPos.x);
            double lastY = tag.getDoubleOr(LAST_POS_Y, currentPos.y);
            double lastZ = tag.getDoubleOr(LAST_POS_Z, currentPos.z);
            Vec3 lastPos = new Vec3(lastX, lastY, lastZ);
            double distance = currentPos.distanceTo(lastPos);
            double spacing = lvl == 1 ? 0.5 : 0.3;
            int steps = Math.max(1, (int)Math.ceil(distance / spacing));
            HashSet<BlockPos> recordedPositions = new HashSet<BlockPos>();
            BlockPos currentBlockPos = BlockPos.containing((Position)currentPos);
            for (int i = 0; i <= steps; ++i) {
                double t = steps > 0 ? (double)i / (double)steps : 0.0;
                Vec3 interpolatedPos = lastPos.lerp(currentPos, t);
                BlockPos icePos = BlockPos.containing((Position)interpolatedPos);
                boolean tooCloseToEntity = false;
                int radius = lvl - 1;
                for (int dx = -radius; dx <= radius; ++dx) {
                    for (int dz = -radius; dz <= radius; ++dz) {
                        if (!icePos.offset(dx, 0, dz).equals((Object)currentBlockPos)) continue;
                        tooCloseToEntity = true;
                        break;
                    }
                    if (tooCloseToEntity) break;
                }
                if (tooCloseToEntity) {
                    if (recordedPositions.contains(icePos)) continue;
                    recordedPositions.add(icePos);
                    CompoundTag posTag = new CompoundTag();
                    posTag.putInt("x", icePos.getX());
                    posTag.putInt("y", icePos.getY());
                    posTag.putInt("z", icePos.getZ());
                    posTag.putInt("tick", tickCounter);
                    posTag.putInt("level", lvl);
                    posTag.putBoolean("needsSafetyCheck", true);
                    delayedList.add((Object)posTag);
                    continue;
                }
                if (recordedPositions.contains(icePos)) continue;
                recordedPositions.add(icePos);
                CompoundTag posTag = new CompoundTag();
                posTag.putInt("x", icePos.getX());
                posTag.putInt("y", icePos.getY());
                posTag.putInt("z", icePos.getZ());
                posTag.putInt("tick", tickCounter);
                posTag.putInt("level", lvl);
                delayedList.add((Object)posTag);
            }
        }
        ListTag newDelayedList = new ListTag();
        BlockPos currentBlockPos = BlockPos.containing((Position)currentPos);
        for (Tag t : delayedList) {
            CompoundTag posTag;
            int recordedTick;
            int delay;
            if (!(t instanceof CompoundTag) || (delay = tickCounter - (recordedTick = (posTag = (CompoundTag)t).getIntOr("tick", 0))) > 10) continue;
            if (delay >= 3) {
                int x = posTag.getIntOr("x", 0);
                int y = posTag.getIntOr("y", 0);
                int z = posTag.getIntOr("z", 0);
                int level_val = posTag.getIntOr("level", 1);
                boolean needsSafetyCheck = posTag.getBooleanOr("needsSafetyCheck", false);
                BlockPos pos = new BlockPos(x, y, z);
                if (needsSafetyCheck) {
                    boolean stillTooClose = false;
                    int safetyRadius = level_val - 1;
                    for (int dx = -safetyRadius; dx <= safetyRadius; ++dx) {
                        for (int dz = -safetyRadius; dz <= safetyRadius; ++dz) {
                            if (!pos.offset(dx, 0, dz).equals((Object)currentBlockPos)) continue;
                            stillTooClose = true;
                            break;
                        }
                        if (stillTooClose) break;
                    }
                    if (stillTooClose) {
                        newDelayedList.add((Object)posTag);
                        continue;
                    }
                }
                int radius = level_val - 1;
                for (int dx = -radius; dx <= radius; ++dx) {
                    for (int dz = -radius; dz <= radius; ++dz) {
                        BlockPos offsetPos = pos.offset(dx, 0, dz);
                        FrostWalkerHelper.placeIce(serverLevel, offsetPos, level_val);
                    }
                }
                continue;
            }
            newDelayedList.add((Object)posTag);
        }
        tag.put(DELAYED_POSITIONS, (Tag)newDelayedList);
        tag.putDouble(LAST_POS_X, currentPos.x);
        tag.putDouble(LAST_POS_Y, currentPos.y);
        tag.putDouble(LAST_POS_Z, currentPos.z);
    }

    private static void generateAllDelayedIce(ServerLevel serverLevel, ListTag delayedList, int lvl) {
        for (Tag t : delayedList) {
            if (!(t instanceof CompoundTag)) continue;
            CompoundTag posTag = (CompoundTag)t;
            int x = posTag.getIntOr("x", 0);
            int y = posTag.getIntOr("y", 0);
            int z = posTag.getIntOr("z", 0);
            int level_val = posTag.getIntOr("level", 1);
            BlockPos pos = new BlockPos(x, y, z);
            int radius = level_val - 1;
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    BlockPos offsetPos = pos.offset(dx, 0, dz);
                    FrostWalkerHelper.placeIce(serverLevel, offsetPos, level_val);
                }
            }
        }
    }

    private static void placeIce(ServerLevel level, BlockPos pos, int enchantLevel) {
        BlockState currentState = level.getBlockState(pos);
        if (currentState.isAir()) {
            BlockState iceState = (BlockState)((CustomFrostedIceBlock)((Object)ModBlocks.CUSTOM_FROSTED_ICE.get())).defaultBlockState().setValue((Property)CustomFrostedIceBlock.AGE, (Comparable)Integer.valueOf(0));
            level.setBlockAndUpdate(pos, iceState);
        }
    }
}

