/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.infinity;

import com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.infinity.TemporaryBlockTracker;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class PistonTemporaryBlockHelper {
    private static final Map<ServerLevel, Map<Integer, TransferTask>> pendingTasks = new HashMap<ServerLevel, Map<Integer, TransferTask>>();
    private static int nextTaskId = 0;

    public static void scheduleTransfer(ServerLevel level, BlockPos from, BlockPos to, int remainingTime, int delayTicks) {
        Map levelTasks = pendingTasks.computeIfAbsent(level, k -> new HashMap());
        levelTasks.put(nextTaskId++, new TransferTask(from, to, remainingTime, delayTicks));
    }

    public static void tickPendingTransfers(ServerLevel level) {
        Map<Integer, TransferTask> levelTasks = pendingTasks.get(level);
        if (levelTasks == null || levelTasks.isEmpty()) {
            return;
        }
        HashMap<Integer, TransferTask> toRemove = new HashMap<Integer, TransferTask>();
        for (Map.Entry<Integer, TransferTask> entry : levelTasks.entrySet()) {
            TransferTask task = entry.getValue();
            --task.ticksLeft;
            if (task.ticksLeft > 0) continue;
            TemporaryBlockTracker.removeTemporary((Level)level, task.from);
            if (!level.getBlockState(task.to).isAir()) {
                TemporaryBlockTracker.markTemporary((Level)level, task.to, task.remainingTime);
            }
            toRemove.put(entry.getKey(), task);
        }
        toRemove.forEach((k, v) -> levelTasks.remove(k));
        if (levelTasks.isEmpty()) {
            pendingTasks.remove(level);
        }
    }

    public static class TransferTask {
        public final BlockPos from;
        public final BlockPos to;
        public final int remainingTime;
        public int ticksLeft;

        public TransferTask(BlockPos from, BlockPos to, int remainingTime, int delayTicks) {
            this.from = from;
            this.to = to;
            this.remainingTime = remainingTime;
            this.ticksLeft = delayTicks;
        }
    }
}

