/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.leaky;

import com.mafuyu33.mafishcrossbow.enchantment.ModEnchantmentHelper;
import com.mafuyu33.mafishcrossbow.entity.custom.BundleProjectile;
import com.mafuyu33.mafishcrossbow.mixinhandler.crossbowmain.CrossbowProjectileStrategyHelper;
import com.mafuyu33.mafishcrossbow.mixinhandler.crossbowmain.livingentityadapt.StaticShooterContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.Vec3;

public class LeakyHelper {
    private static final int BASE_RELEASE_INTERVAL = 5;
    private static final double RELEASE_SPEED = 0.01;

    public static void update(BundleProjectile bundle, int tickCount) {
        if (bundle.level().isClientSide()) {
            return;
        }
        CompoundTag tag = bundle.getPersistentData();
        if (!tag.contains("mafishcrossbow_leaky")) {
            return;
        }
        int level = tag.getIntOr("mafishcrossbow_leaky", 0);
        if (level <= 0) {
            return;
        }
        int releaseInterval = Math.max(1, 5 - (level - 1));
        if (tickCount % releaseInterval != 0) {
            return;
        }
        ItemStack bundleItem = bundle.getItem();
        BundleContents contents = (BundleContents)bundleItem.get(DataComponents.BUNDLE_CONTENTS);
        if (contents == null || contents.isEmpty()) {
            return;
        }
        int releaseCount = 1;
        boolean hasBundleInfinity = ModEnchantmentHelper.getEnchantmentLevel((ResourceKey<Enchantment>)Enchantments.INFINITY, bundleItem) > 0;
        RandomSource rand = bundle.level().random;
        Vec3 bundlePos = bundle.position();
        if (hasBundleInfinity) {
            ArrayList allItems = new ArrayList();
            contents.itemCopyStream().forEach(allItems::add);
            if (allItems.isEmpty()) {
                return;
            }
            int currentIndex = tag.getIntOr("mafishcrossbow_leaky_index", 0);
            for (int i = 0; i < releaseCount; ++i) {
                LivingEntity l;
                ItemStack stack = (ItemStack)allItems.get(currentIndex % allItems.size());
                ItemStack toRelease = stack.copy();
                toRelease.setCount(1);
                double angle = rand.nextDouble() * 2.0 * Math.PI;
                double horizontalDist = rand.nextDouble() * 0.5 + 0.5;
                double dx = Math.cos(angle) * horizontalDist;
                double dz = Math.sin(angle) * horizontalDist;
                double dy = -1.0;
                Vec3 direction = new Vec3(dx, dy, dz).normalize();
                Entity entity = bundle.getOwner();
                StaticShooterContext ctx = new StaticShooterContext(bundlePos, direction, entity instanceof LivingEntity ? (l = (LivingEntity)entity) : null, true);
                Projectile proj = CrossbowProjectileStrategyHelper.tryHandleCompatibleProjectile(bundle.level(), ctx, bundleItem, toRelease);
                if (proj != null) {
                    proj.setPos(bundlePos.x, bundlePos.y, bundlePos.z);
                    proj.setDeltaMovement(direction.scale(0.01));
                    bundle.level().addFreshEntity((Entity)proj);
                }
                ++currentIndex;
            }
            tag.putInt("mafishcrossbow_leaky_index", currentIndex);
        } else {
            ArrayList allItems = new ArrayList();
            contents.itemCopyStream().forEach(allItems::add);
            if (allItems.isEmpty()) {
                return;
            }
            for (int i = 0; i < releaseCount && !allItems.isEmpty(); ++i) {
                LivingEntity l;
                ItemStack stack = (ItemStack)allItems.get(0);
                ItemStack toRelease = stack.copy();
                toRelease.setCount(1);
                stack.shrink(1);
                if (stack.isEmpty()) {
                    allItems.remove(0);
                }
                double angle = rand.nextDouble() * 2.0 * Math.PI;
                double horizontalDist = rand.nextDouble() * 0.5 + 0.5;
                double dx = Math.cos(angle) * horizontalDist;
                double dz = Math.sin(angle) * horizontalDist;
                double dy = -1.0;
                Vec3 direction = new Vec3(dx, dy, dz).normalize();
                Entity entity = bundle.getOwner();
                StaticShooterContext ctx = new StaticShooterContext(bundlePos, direction, entity instanceof LivingEntity ? (l = (LivingEntity)entity) : null, false);
                Projectile proj = CrossbowProjectileStrategyHelper.tryHandleCompatibleProjectile(bundle.level(), ctx, bundleItem, toRelease);
                if (proj == null) continue;
                proj.setPos(bundlePos.x, bundlePos.y, bundlePos.z);
                proj.setDeltaMovement(direction.scale(0.01));
                bundle.level().addFreshEntity((Entity)proj);
            }
            if (!allItems.isEmpty()) {
                BundleContents newContents = new BundleContents(List.copyOf(allItems));
                bundle.updateContents(newContents);
            } else {
                bundle.updateContents(BundleContents.EMPTY);
            }
        }
    }
}

