/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.piercing;

import com.mafuyu33.mafishcrossbow.entity.TrailEntity;
import java.util.Arrays;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.entity.projectile.windcharge.AbstractWindCharge;

public class PiercingHelper {
    private static final ThreadLocal<Boolean> inPiercingCheck = ThreadLocal.withInitial(() -> false);
    private static final Map<Projectile, Boolean> justHitEntityMap = new WeakHashMap<Projectile, Boolean>();

    public static boolean hasPiercingTag(Entity projectile) {
        CompoundTag tag = projectile.getPersistentData();
        boolean has = tag.contains("mafishcrossbow_piercing_level");
        if (has) {
            // empty if block
        }
        return has;
    }

    public static int getPiercingLevel(Entity projectile) {
        CompoundTag tag = projectile.getPersistentData();
        return tag.getIntOr("mafishcrossbow_piercing_level", 0);
    }

    public static boolean hasAlreadyPierced(Entity projectile, int targetId) {
        CompoundTag tag = projectile.getPersistentData();
        int[] piercedEntities = tag.getIntArray("mafishcrossbow_pierced_entities").orElse(new int[0]);
        return Arrays.stream(piercedEntities).anyMatch(id -> id == targetId);
    }

    public static void recordPiercedEntity(Entity projectile, int entityId) {
        CompoundTag tag = projectile.getPersistentData();
        int[] piercedEntities = tag.getIntArray("mafishcrossbow_pierced_entities").orElse(new int[0]);
        int[] newArray = Arrays.copyOf(piercedEntities, piercedEntities.length + 1);
        newArray[piercedEntities.length] = entityId;
        tag.putIntArray("mafishcrossbow_pierced_entities", newArray);
    }

    public static boolean shouldDiscardAfterHit(Entity projectile) {
        if (!PiercingHelper.hasPiercingTag(projectile)) {
            return true;
        }
        int piercingLevel = PiercingHelper.getPiercingLevel(projectile);
        CompoundTag tag = projectile.getPersistentData();
        int[] piercedEntities = tag.getIntArray("mafishcrossbow_pierced_entities").orElse(new int[0]);
        boolean shouldDiscard = piercedEntities.length >= piercingLevel + 1;
        return shouldDiscard;
    }

    public static boolean shouldPierceEntity(Entity projectile, Entity target) {
        if (!PiercingHelper.hasPiercingTag(projectile)) {
            return false;
        }
        int targetId = target.getId();
        return !PiercingHelper.hasAlreadyPierced(projectile, targetId);
    }

    public static int getPiercedEntityCount(Entity projectile) {
        CompoundTag tag = projectile.getPersistentData();
        int[] piercedEntities = tag.getIntArray("mafishcrossbow_pierced_entities").orElse(new int[0]);
        return piercedEntities.length;
    }

    public static void markEntityHit(Projectile projectile) {
        justHitEntityMap.put(projectile, true);
    }

    public static void clearEntityHitFlag(Projectile projectile) {
        justHitEntityMap.remove(projectile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shouldCancelDiscard(Entity entity) {
        if (inPiercingCheck.get().booleanValue()) {
            return false;
        }
        if (!(entity instanceof Projectile)) {
            return false;
        }
        Projectile projectile = (Projectile)entity;
        if (projectile instanceof AbstractArrow) {
            return false;
        }
        if (projectile instanceof ThrownTrident) {
            return false;
        }
        if (projectile instanceof TrailEntity) {
            return false;
        }
        boolean isThrowableProjectile = projectile instanceof ThrowableProjectile;
        boolean isWindCharge = projectile instanceof AbstractWindCharge;
        if (!isThrowableProjectile && !isWindCharge) {
            return false;
        }
        if (!PiercingHelper.hasPiercingTag((Entity)projectile)) {
            return false;
        }
        if (justHitEntityMap.getOrDefault(projectile, false).booleanValue()) {
            inPiercingCheck.set(true);
            try {
                if (!PiercingHelper.shouldDiscardAfterHit((Entity)projectile)) {
                    boolean bl = true;
                    return bl;
                }
                justHitEntityMap.remove(projectile);
                boolean bl = false;
                return bl;
            }
            finally {
                inPiercingCheck.set(false);
            }
        }
        return false;
    }
}

