/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.redirect;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.phys.Vec3;

public class RedirectHelper {
    public static void update(Entity self, CompoundTag tag) {
        boolean playerIsRiding;
        Player player;
        int lvl;
        block14: {
            if (!tag.contains("mafishcrossbow_redirect") || self.level().isClientSide()) {
                return;
            }
            lvl = tag.getIntOr("mafishcrossbow_redirect", -1);
            if (lvl <= 0) {
                return;
            }
            int shooterId = tag.getIntOr("mafishcrossbow_shooterid", -1);
            if (shooterId == -1) {
                return;
            }
            Entity shooter = self.level().getEntity(shooterId);
            if (!(shooter instanceof Player)) {
                return;
            }
            player = (Player)shooter;
            if (self instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)self;
                try {
                    boolean inGround = ((AbstractArrow)self).onGround();
                    if (inGround) {
                        return;
                    }
                    break block14;
                }
                catch (Exception e) {
                    if (self.getDeltaMovement().lengthSqr() < 0.01) {
                        return;
                    }
                    break block14;
                }
            }
            if (self.getDeltaMovement().lengthSqr() < 0.01) {
                return;
            }
        }
        Vec3 lookDir = player.getLookAngle().normalize();
        boolean bl = playerIsRiding = self.getFirstPassenger() == player;
        if (playerIsRiding) {
            Vec3 currentVelocity = self.getDeltaMovement();
            double currentSpeed = currentVelocity.length();
            double controlStrength = Math.min(1.0, 0.05 * (double)lvl);
            double targetSpeed = Math.max(currentSpeed, 0.5);
            Vec3 targetVelocity = lookDir.scale(targetSpeed);
            Vec3 newVelocity = currentVelocity.scale(1.0 - controlStrength).add(targetVelocity.scale(controlStrength));
            double maxSpeed = 5.0;
            double speedSqr = newVelocity.lengthSqr();
            if (speedSqr > maxSpeed * maxSpeed) {
                newVelocity = newVelocity.normalize().scale(maxSpeed);
            }
            self.setDeltaMovement(newVelocity);
            self.hurtMarked = true;
            return;
        }
        Vec3 rayOrigin = player.getEyePosition();
        Vec3 projectilePos = self.position();
        Vec3 toProjectile = projectilePos.subtract(rayOrigin);
        double projectionLength = toProjectile.dot(lookDir);
        Vec3 projection = lookDir.scale(projectionLength);
        Vec3 perpOffset = toProjectile.subtract(projection);
        Vec3 currentVelocity = self.getDeltaMovement();
        double parallelSpeed = currentVelocity.dot(lookDir);
        Vec3 parallelVelocity = lookDir.scale(parallelSpeed);
        Vec3 perpVelocity = currentVelocity.subtract(parallelVelocity);
        double dampingFactor = Math.max(0.0, 1.0 - 0.03 * (double)lvl);
        Vec3 dampedPerpVelocity = perpVelocity.scale(dampingFactor);
        double perpDistSqr = perpOffset.lengthSqr();
        if (perpDistSqr > 0.01) {
            double pullStrength = Math.min(5.0, 0.1 * (double)lvl);
            Vec3 pullVelocity = perpOffset.normalize().scale(-pullStrength);
            dampedPerpVelocity = dampedPerpVelocity.add(pullVelocity);
        }
        Vec3 newVelocity = parallelVelocity.add(dampedPerpVelocity);
        double maxSpeed = 5.0;
        double speedSqr = newVelocity.lengthSqr();
        if (speedSqr > maxSpeed * maxSpeed) {
            newVelocity = newVelocity.normalize().scale(maxSpeed);
        }
        self.setDeltaMovement(newVelocity);
        self.hurtMarked = true;
    }
}

