/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.silktouch;

import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public final class SilkTouchHelper {
    private static final String TAG_KEY = "mafishcrossbow_silktouch";
    private static final String TAG_MAX_COUNT = "mafishcrossbow_silktouch_max";
    private static final String TAG_MINE_COUNT = "mafishcrossbow_silktouch_count";
    private static final String TAG_PIERCING = "mafishcrossbow_silktouch_piercing";
    private static final String TAG_PIERCE_LEFT = "mafishcrossbow_silktouch_pierce_left";
    private static final String TAG_LAST_X = "mafishcrossbow_silktouch_last_x";
    private static final String TAG_LAST_Y = "mafishcrossbow_silktouch_last_y";
    private static final String TAG_LAST_Z = "mafishcrossbow_silktouch_last_z";
    private static final String TAG_HAS_LAST_POS = "mafishcrossbow_silktouch_has_last";
    private static final Map<Entity, Boolean> justPiercedBlockMap = new WeakHashMap<Entity, Boolean>();
    private static final Map<Entity, BlockPos> lastMinedPosMap = new WeakHashMap<Entity, BlockPos>();

    public static boolean hasSilkTouch(CompoundTag tag) {
        return tag.contains(TAG_KEY) && tag.getIntOr(TAG_KEY, 0) > 0;
    }

    public static int getSilkTouchLevel(CompoundTag tag) {
        return tag.getIntOr(TAG_KEY, 0);
    }

    private static int getMaxMineCount(CompoundTag tag) {
        return tag.getIntOr(TAG_MAX_COUNT, 1);
    }

    private static int getMineCount(CompoundTag tag) {
        return tag.getIntOr(TAG_MINE_COUNT, 0);
    }

    private static boolean canMineMore(CompoundTag tag) {
        return SilkTouchHelper.getMineCount(tag) < SilkTouchHelper.getMaxMineCount(tag);
    }

    private static void incrementMineCount(CompoundTag tag) {
        int current = SilkTouchHelper.getMineCount(tag);
        tag.putInt(TAG_MINE_COUNT, current + 1);
    }

    private static int getPiercingLevel(CompoundTag tag) {
        return tag.getIntOr(TAG_PIERCING, 0);
    }

    private static int getPierceLeft(CompoundTag tag) {
        return tag.getIntOr(TAG_PIERCE_LEFT, 0);
    }

    private static void decrementPierceLeft(CompoundTag tag) {
        int current = SilkTouchHelper.getPierceLeft(tag);
        if (current > 0) {
            tag.putInt(TAG_PIERCE_LEFT, current - 1);
        }
    }

    public static void resetPierceLeft(CompoundTag tag) {
        int piercingLvl = SilkTouchHelper.getPiercingLevel(tag);
        tag.putInt(TAG_PIERCE_LEFT, piercingLvl + 1);
    }

    public static boolean shouldPierceBlock(CompoundTag tag) {
        return SilkTouchHelper.getPierceLeft(tag) > 0 && SilkTouchHelper.canMineMore(tag);
    }

    public static void markBlockPierced(Entity entity) {
        justPiercedBlockMap.put(entity, true);
    }

    public static boolean checkAndClearBlockPierced(Entity entity) {
        return justPiercedBlockMap.remove(entity) != null;
    }

    public static SilkTouchResult onHitBlockWithResult(Entity entity, CompoundTag tag, BlockHitResult hitResult) {
        BlockPos lastMinedPos;
        if (entity.level().isClientSide()) {
            return SilkTouchResult.NONE;
        }
        if (!SilkTouchHelper.hasSilkTouch(tag)) {
            return SilkTouchResult.NONE;
        }
        if (!SilkTouchHelper.canMineMore(tag)) {
            return SilkTouchResult.NONE;
        }
        BlockPos pos = hitResult.getBlockPos();
        BlockState stateAtPos = entity.level().getBlockState(pos);
        if (stateAtPos.isAir()) {
            BlockPos actualPos = pos.relative(hitResult.getDirection().getOpposite());
            BlockState actualState = entity.level().getBlockState(actualPos);
            if (!actualState.isAir()) {
                pos = actualPos;
            }
        }
        if ((lastMinedPos = lastMinedPosMap.get(entity)) != null && lastMinedPos.equals((Object)pos)) {
            return SilkTouchResult.PIERCE;
        }
        boolean success = SilkTouchHelper.mineBlockWithSilkTouch(entity, pos);
        if (!success) {
            tag.putInt(TAG_PIERCE_LEFT, 0);
            return SilkTouchResult.NONE;
        }
        lastMinedPosMap.put(entity, pos.immutable());
        SilkTouchHelper.incrementMineCount(tag);
        SilkTouchHelper.decrementPierceLeft(tag);
        if (SilkTouchHelper.shouldPierceBlock(tag)) {
            SilkTouchHelper.markBlockPierced(entity);
            return SilkTouchResult.PIERCE;
        }
        return SilkTouchResult.STOP;
    }

    @Deprecated
    public static boolean onHitBlock(Entity entity, CompoundTag tag, BlockHitResult hitResult) {
        SilkTouchResult result = SilkTouchHelper.onHitBlockWithResult(entity, tag, hitResult);
        return result == SilkTouchResult.PIERCE;
    }

    private static boolean mineBlockWithSilkTouch(Entity entity, BlockPos pos) {
        Level level = entity.level();
        if (level.isClientSide() || !(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        BlockState state = level.getBlockState(pos);
        if (state.isAir() || state.getDestroySpeed((BlockGetter)level, pos) < 0.0f) {
            return false;
        }
        if (!SilkTouchHelper.canSilkTouch(state)) {
            return false;
        }
        ItemStack drop = SilkTouchHelper.getSilkTouchDrop(state);
        level.removeBlock(pos, false);
        if (!drop.isEmpty()) {
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)drop);
        }
        return true;
    }

    private static ItemStack getSilkTouchDrop(BlockState state) {
        Block block = state.getBlock();
        ItemStack drop = new ItemStack((ItemLike)block);
        if (drop.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return drop;
    }

    private static boolean canSilkTouch(BlockState state) {
        Block block = state.getBlock();
        return block != Blocks.AIR && block != Blocks.BEDROCK && block != Blocks.END_PORTAL_FRAME && block != Blocks.END_PORTAL && block != Blocks.NETHER_PORTAL && block != Blocks.SPAWNER && block != Blocks.REINFORCED_DEEPSLATE && block != Blocks.BUDDING_AMETHYST;
    }

    private SilkTouchHelper() {
    }

    public static enum SilkTouchResult {
        NONE,
        PIERCE,
        STOP;

    }
}

