/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.silktouch;

import com.mafuyu33.mafishcrossbow.api.EntityModifier;
import com.mafuyu33.mafishcrossbow.api.ShooterContext;
import com.mafuyu33.mafishcrossbow.enchantment.ModEnchantmentHelper;
import com.mafuyu33.mafishcrossbow.enchantment.datagen.custom.ModEnchantments;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;

public class SilkTouchModifier
implements EntityModifier {
    @Override
    public void apply(Entity entity, ItemStack weapon, ItemStack ammo, ShooterContext context) {
        int silkTouchLvl = ModEnchantmentHelper.getEnchantmentLevel((ResourceKey<Enchantment>)Enchantments.SILK_TOUCH, weapon);
        if (silkTouchLvl > 0) {
            entity.getPersistentData().putInt("mafishcrossbow_silktouch", silkTouchLvl);
            int piercingLvl = ModEnchantmentHelper.getEnchantmentLevel((ResourceKey<Enchantment>)Enchantments.PIERCING, weapon);
            entity.getPersistentData().putInt("mafishcrossbow_silktouch_piercing", piercingLvl);
            entity.getPersistentData().putInt("mafishcrossbow_silktouch_pierce_left", piercingLvl + 1);
            int bounceLvl = ModEnchantmentHelper.getEnchantmentLevel(ModEnchantments.BOUNCE, weapon);
            int maxMineCount = (bounceLvl + 1) * (piercingLvl + 1);
            entity.getPersistentData().putInt("mafishcrossbow_silktouch_max", maxMineCount);
            entity.getPersistentData().putInt("mafishcrossbow_silktouch_count", 0);
        }
    }
}

