/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.trail;

import com.mafuyu33.mafishcrossbow.entity.TrailEntity;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class TrailHelper {
    public static void spawnTrailParticles(Entity entity) {
        SimpleParticleType particle;
        Level level = entity.level();
        if (!level.isClientSide()) {
            return;
        }
        CompoundTag tag = entity.getPersistentData();
        String trailType = tag.getStringOr("mafishcrossbow_trail_type", "none");
        if (entity instanceof TrailEntity) {
            TrailEntity trailEntity = (TrailEntity)entity;
            trailType = trailEntity.getTrailType();
        }
        if (trailType.isEmpty() || trailType.equals("none")) {
            return;
        }
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        switch (trailType) {
            case "smoke": {
                SimpleParticleType simpleParticleType = ParticleTypes.SMOKE;
                break;
            }
            case "spark": {
                SimpleParticleType simpleParticleType = ParticleTypes.CRIT;
                break;
            }
            case "normal": 
            case "dust": 
            case "custom": {
                int from = tag.getIntOr("mafishcrossbow_trail_color_from", 0xFFFFFF);
                int to = tag.getIntOr("mafishcrossbow_trail_color_to", 12051455);
                float scale = 1.0f;
                SimpleParticleType simpleParticleType = new DustColorTransitionOptions(from, to, scale);
                break;
            }
            default: {
                SimpleParticleType simpleParticleType = particle = ParticleTypes.UNDERWATER;
            }
        }
        if (particle != ParticleTypes.UNDERWATER) {
            level.addParticle((ParticleOptions)particle, x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

