/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.modifier.custom.turretenderpearl;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;

public class TurretEnderPearlHelper {
    private static final String TURRET_FIRED_TAG = "mafishcrossbow_turret_fired";
    private static final String TURRET_UUID_MOST_TAG = "mafishcrossbow_turret_uuid_most";
    private static final String TURRET_UUID_LEAST_TAG = "mafishcrossbow_turret_uuid_least";
    private static final String TURRET_DIMENSION_TAG = "mafishcrossbow_turret_dimension";

    public static boolean isTurretFired(Projectile projectile) {
        return projectile.getPersistentData().getBooleanOr(TURRET_FIRED_TAG, false);
    }

    public static void markAsTurretFired(ThrownEnderpearl enderPearl, UUID turretUUID, String dimension) {
        if (enderPearl == null || turretUUID == null || dimension == null) {
            return;
        }
        CompoundTag tag = enderPearl.getPersistentData();
        tag.putBoolean(TURRET_FIRED_TAG, true);
        tag.putLong(TURRET_UUID_MOST_TAG, turretUUID.getMostSignificantBits());
        tag.putLong(TURRET_UUID_LEAST_TAG, turretUUID.getLeastSignificantBits());
        tag.putString(TURRET_DIMENSION_TAG, dimension);
    }

    public static UUID getTurretUUID(Projectile projectile) {
        CompoundTag tag = projectile.getPersistentData();
        if (!tag.contains(TURRET_UUID_MOST_TAG) || !tag.contains(TURRET_UUID_LEAST_TAG)) {
            return null;
        }
        long most = tag.getLong(TURRET_UUID_MOST_TAG).orElse(0L);
        long least = tag.getLong(TURRET_UUID_LEAST_TAG).orElse(0L);
        return new UUID(most, least);
    }

    public static String getTurretDimension(Projectile projectile) {
        return projectile.getPersistentData().getString(TURRET_DIMENSION_TAG).orElse(null);
    }

    public static void copyTurretMark(Projectile source, Projectile target) {
        if (!TurretEnderPearlHelper.isTurretFired(source)) {
            return;
        }
        UUID turretUUID = TurretEnderPearlHelper.getTurretUUID(source);
        String dimension = TurretEnderPearlHelper.getTurretDimension(source);
        if (turretUUID != null && dimension != null && target instanceof ThrownEnderpearl) {
            ThrownEnderpearl enderPearl = (ThrownEnderpearl)target;
            TurretEnderPearlHelper.markAsTurretFired(enderPearl, turretUUID, dimension);
        }
    }
}

