/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.mixinhandler.turret;

import com.mafuyu33.mafishcrossbow.MafishCrossbow;
import com.mafuyu33.mafishcrossbow.block.entity.CrossbowTurretBlockEntity;
import com.mafuyu33.mafishcrossbow.mixin.accessor.ChunkMapAccessor;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public class EnderPearlTurretHelper {
    public static boolean isTurretFired(ThrownEnderpearl enderPearl) {
        CompoundTag tag = enderPearl.getPersistentData();
        return tag.contains("turret_fired") && tag.getBoolean("turret_fired").orElse(false) != false;
    }

    public static boolean tryTeleportTurret(ThrownEnderpearl enderPearl, Vec3 landingPos) {
        CompoundTag turretData;
        Level level = enderPearl.level();
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        CompoundTag tag = enderPearl.getPersistentData();
        if (!tag.contains("turret_fired") || !tag.getBoolean("turret_fired").orElse(false).booleanValue()) {
            return false;
        }
        if (!tag.contains("turret_uuid_most") || !tag.contains("turret_uuid_least")) {
            MafishCrossbow.LOGGER.warn("Ender pearl missing turret UUID");
            return false;
        }
        long most = tag.getLong("turret_uuid_most").orElse(0L);
        long least = tag.getLong("turret_uuid_least").orElse(0L);
        UUID turretUUID = new UUID(most, least);
        String dimensionString = tag.getString("turret_dimension").orElse("");
        ResourceLocation dimensionLocation = ResourceLocation.tryParse((String)dimensionString);
        if (dimensionLocation == null) {
            MafishCrossbow.LOGGER.error("Invalid dimension string: {}", (Object)dimensionString);
            return false;
        }
        ResourceKey dimensionKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimensionLocation);
        ServerLevel turretLevel = serverLevel.getServer().getLevel(dimensionKey);
        if (turretLevel == null) {
            MafishCrossbow.LOGGER.error("Could not find dimension: {}", (Object)dimensionString);
            return false;
        }
        CrossbowTurretBlockEntity turretBlockEntity = EnderPearlTurretHelper.findTurretByUUID(turretLevel, turretUUID);
        if (turretBlockEntity == null) {
            MafishCrossbow.LOGGER.warn("No turret found with UUID: {}", (Object)turretUUID);
            return false;
        }
        BlockPos turretPos = turretBlockEntity.getBlockPos();
        BlockState turretState = turretLevel.getBlockState(turretPos);
        BlockPos newTurretPos = BlockPos.containing((double)landingPos.x, (double)landingPos.y, (double)landingPos.z);
        if (newTurretPos.getY() < serverLevel.getMinY() || newTurretPos.getY() > serverLevel.getMaxY()) {
            MafishCrossbow.LOGGER.warn("Invalid target position Y: {}", (Object)newTurretPos.getY());
            return false;
        }
        BlockState targetState = serverLevel.getBlockState(newTurretPos);
        if (!targetState.canBeReplaced()) {
            BlockPos checkPos;
            boolean foundSpace = false;
            for (int i = 0; i < 8 && (checkPos = newTurretPos.above(i)).getY() <= serverLevel.getMaxY(); ++i) {
                BlockState checkState = serverLevel.getBlockState(checkPos);
                if (!checkState.canBeReplaced()) continue;
                newTurretPos = checkPos;
                foundSpace = true;
                break;
            }
            if (!foundSpace) {
                MafishCrossbow.LOGGER.warn("No valid space found near landing position: {}", (Object)newTurretPos);
                return false;
            }
        }
        try (ProblemReporter.ScopedCollector reporter = new ProblemReporter.ScopedCollector(turretBlockEntity.problemPath(), MafishCrossbow.LOGGER);){
            RegistryAccess registryAccess = turretLevel.registryAccess();
            TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)reporter, (HolderLookup.Provider)registryAccess);
            turretBlockEntity.saveWithoutMetadata((ValueOutput)output);
            turretData = output.buildResult();
        }
        catch (Exception e) {
            MafishCrossbow.LOGGER.error("Failed to save turret data", (Throwable)e);
            return false;
        }
        EnderPearlTurretHelper.spawnTeleportParticles((Level)turretLevel, turretPos);
        turretBlockEntity.clearContent();
        turretLevel.setBlock(turretPos, Blocks.AIR.defaultBlockState(), 3);
        serverLevel.setBlock(newTurretPos, turretState, 3);
        EnderPearlTurretHelper.spawnTeleportParticles((Level)serverLevel, newTurretPos);
        BlockEntity newTurretEntity = serverLevel.getBlockEntity(newTurretPos);
        if (newTurretEntity instanceof CrossbowTurretBlockEntity) {
            CrossbowTurretBlockEntity newTurret = (CrossbowTurretBlockEntity)newTurretEntity;
            try (ProblemReporter.ScopedCollector reporter = new ProblemReporter.ScopedCollector(newTurret.problemPath(), MafishCrossbow.LOGGER);){
                RegistryAccess registryAccess = serverLevel.registryAccess();
                ValueInput input = TagValueInput.create((ProblemReporter)reporter, (HolderLookup.Provider)registryAccess, (CompoundTag)turretData);
                newTurret.loadWithComponents(input);
                newTurret.setChanged();
            }
            catch (Exception e) {
                MafishCrossbow.LOGGER.error("Failed to load turret data", (Throwable)e);
                return false;
            }
            MafishCrossbow.LOGGER.info("Successfully teleported turret from {} to {}", (Object)turretPos, (Object)newTurretPos);
            return true;
        }
        MafishCrossbow.LOGGER.error("Failed to create turret at new position: {}", (Object)newTurretPos);
        return false;
    }

    private static CrossbowTurretBlockEntity findTurretByUUID(ServerLevel level, UUID turretUUID) {
        try {
            ChunkMap chunkMap = level.getChunkSource().chunkMap;
            Iterable<ChunkHolder> visibleChunks = ((ChunkMapAccessor)chunkMap).invokeGetChunks();
            for (ChunkHolder chunkHolder : visibleChunks) {
                LevelChunk chunk = chunkHolder.getTickingChunk();
                if (chunk == null) continue;
                for (BlockEntity blockEntity : chunk.getBlockEntities().values()) {
                    CrossbowTurretBlockEntity turret;
                    if (!(blockEntity instanceof CrossbowTurretBlockEntity) || !turretUUID.equals((turret = (CrossbowTurretBlockEntity)blockEntity).getTurretUUID())) continue;
                    return turret;
                }
            }
        }
        catch (Exception e) {
            MafishCrossbow.LOGGER.error("Error searching for turret by UUID", (Throwable)e);
        }
        return null;
    }

    private static void spawnTeleportParticles(Level level, BlockPos pos) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        for (int i = 0; i < 32; ++i) {
            double offsetX = (serverLevel.random.nextDouble() - 0.5) * 2.0;
            double offsetY = serverLevel.random.nextDouble() * 2.0;
            double offsetZ = (serverLevel.random.nextDouble() - 0.5) * 2.0;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.PORTAL, (double)pos.getX() + 0.5 + offsetX * 0.5, (double)pos.getY() + 0.5 + offsetY, (double)pos.getZ() + 0.5 + offsetZ * 0.5, 1, serverLevel.random.nextGaussian() * 0.1, 0.0, serverLevel.random.nextGaussian() * 0.1, 0.0);
        }
    }
}

