/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.network.packet.C2S;

import com.mafuyu33.mafishcrossbow.MafishCrossbow;
import com.mafuyu33.mafishcrossbow.gui.EnchantmentTableMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record ItemRenameC2SPacket(String itemName) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ItemRenameC2SPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mafishcrossbow", (String)"item_rename"));
    public static final StreamCodec<FriendlyByteBuf, ItemRenameC2SPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, ItemRenameC2SPacket::itemName, ItemRenameC2SPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ItemRenameC2SPacket payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                AbstractContainerMenu patt1$temp = player.containerMenu;
                if (!(patt1$temp instanceof EnchantmentTableMenu)) {
                    MafishCrossbow.LOGGER.warn("Player {} tried to rename item but container is not EnchantmentTableMenu", (Object)player.getName().getString());
                    return;
                }
                EnchantmentTableMenu menu = (EnchantmentTableMenu)patt1$temp;
                if (!menu.stillValid((Player)player)) {
                    MafishCrossbow.LOGGER.warn("Player {} tried to rename item but menu is invalid", (Object)player.getName().getString());
                    return;
                }
                menu.setItemName(payload.itemName());
            }
        });
    }
}

