/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.network.packet.C2S;

import com.mafuyu33.mafishcrossbow.MafishCrossbow;
import com.mafuyu33.mafishcrossbow.block.entity.CrossbowPresetWorkbenchBlockEntity;
import com.mafuyu33.mafishcrossbow.gui.CrossbowPresetWorkbenchMenu;
import com.mafuyu33.mafishcrossbow.network.packet.S2C.PresetWorkbenchResultS2CPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PresetWorkbenchActionC2SPacket(Action action, BlockPos blockPos, String encodedString, String presetName, boolean addToLootPool) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PresetWorkbenchActionC2SPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mafishcrossbow", (String)"preset_workbench_action"));
    public static final StreamCodec<FriendlyByteBuf, PresetWorkbenchActionC2SPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT.map(i -> Action.values()[i], Enum::ordinal), PresetWorkbenchActionC2SPacket::action, (StreamCodec)BlockPos.STREAM_CODEC, PresetWorkbenchActionC2SPacket::blockPos, (StreamCodec)ByteBufCodecs.STRING_UTF8, PresetWorkbenchActionC2SPacket::encodedString, (StreamCodec)ByteBufCodecs.STRING_UTF8, PresetWorkbenchActionC2SPacket::presetName, (StreamCodec)ByteBufCodecs.BOOL, PresetWorkbenchActionC2SPacket::addToLootPool, PresetWorkbenchActionC2SPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(PresetWorkbenchActionC2SPacket payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            String resultMessage;
            boolean success;
            Player patt0$temp = context.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            BlockEntity patt1$temp = player.level().getBlockEntity(payload.blockPos());
            if (!(patt1$temp instanceof CrossbowPresetWorkbenchBlockEntity)) {
                MafishCrossbow.LOGGER.warn("[PresetWorkbench] \u65e0\u6cd5\u83b7\u53d6\u65b9\u5757\u5b9e\u4f53: {}", (Object)payload.blockPos());
                return;
            }
            CrossbowPresetWorkbenchBlockEntity workbench = (CrossbowPresetWorkbenchBlockEntity)patt1$temp;
            if (player.distanceToSqr((double)payload.blockPos().getX() + 0.5, (double)payload.blockPos().getY() + 0.5, (double)payload.blockPos().getZ() + 0.5) > 64.0) {
                MafishCrossbow.LOGGER.warn("[PresetWorkbench] \u73a9\u5bb6\u8ddd\u79bb\u8fc7\u8fdc");
                return;
            }
            String resultEncodedString = "";
            String resultPresetName = "";
            switch (payload.action().ordinal()) {
                case 0: {
                    String encoded = workbench.encodeInputCrossbow();
                    success = encoded != null && !encoded.isEmpty();
                    resultMessage = success ? "gui.mafishcrossbow.encode_success" : "gui.mafishcrossbow.encode_failed";
                    String string = resultEncodedString = encoded != null ? encoded : "";
                    if (!success) break;
                    resultPresetName = workbench.getInputCrossbowName();
                    break;
                }
                case 1: {
                    AbstractContainerMenu patt2$temp;
                    success = workbench.decodeToOutputSlot(payload.encodedString());
                    resultMessage = success ? "gui.mafishcrossbow.decode_success" : "gui.mafishcrossbow.decode_failed";
                    resultEncodedString = payload.encodedString();
                    if (!success || !((patt2$temp = player.containerMenu) instanceof CrossbowPresetWorkbenchMenu)) break;
                    CrossbowPresetWorkbenchMenu menu = (CrossbowPresetWorkbenchMenu)patt2$temp;
                    menu.moveInputSlotToPlayer();
                    break;
                }
                case 2: {
                    String toSave = payload.encodedString();
                    if (toSave.isEmpty()) {
                        toSave = workbench.encodeInputCrossbow();
                    }
                    if (toSave != null && !toSave.isEmpty()) {
                        workbench.setCurrentEncodedString(toSave);
                        success = workbench.savePreset(payload.presetName(), payload.addToLootPool());
                        resultEncodedString = toSave;
                    } else {
                        success = false;
                    }
                    resultMessage = success ? "gui.mafishcrossbow.save_success" : "gui.mafishcrossbow.save_failed";
                    break;
                }
                case 3: {
                    AbstractContainerMenu patt2$temp = player.containerMenu;
                    if (patt2$temp instanceof CrossbowPresetWorkbenchMenu) {
                        CrossbowPresetWorkbenchMenu menu = (CrossbowPresetWorkbenchMenu)patt2$temp;
                        menu.moveInputSlotToPlayer();
                    }
                    String string = resultMessage = (success = workbench.loadPreset(payload.presetName())) ? "gui.mafishcrossbow.get_success" : "gui.mafishcrossbow.get_failed";
                    if (!success) break;
                    resultEncodedString = workbench.getCurrentEncodedString();
                    break;
                }
                case 4: {
                    success = workbench.deletePreset(payload.presetName());
                    resultMessage = success ? "gui.mafishcrossbow.delete_success" : "gui.mafishcrossbow.delete_failed";
                    break;
                }
                case 5: {
                    AbstractContainerMenu patt2$temp = player.containerMenu;
                    if (patt2$temp instanceof CrossbowPresetWorkbenchMenu) {
                        CrossbowPresetWorkbenchMenu menu = (CrossbowPresetWorkbenchMenu)patt2$temp;
                        menu.moveInputSlotToPlayer();
                    }
                    resultMessage = (success = workbench.loadBuiltinPreset(payload.presetName(), (Player)player)) ? "gui.mafishcrossbow.get_success" : "gui.mafishcrossbow.get_failed";
                    break;
                }
                case 6: {
                    PresetWorkbenchActionC2SPacket.sendPresetListToPlayer(player, workbench);
                    success = true;
                    resultMessage = "";
                    break;
                }
                default: {
                    success = false;
                    resultMessage = "gui.mafishcrossbow.unknown_action";
                }
            }
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PresetWorkbenchResultS2CPacket(success, resultMessage, resultEncodedString, resultPresetName), (CustomPacketPayload[])new CustomPacketPayload[0]);
            if (success && (payload.action() == Action.SAVE || payload.action() == Action.DELETE)) {
                PresetWorkbenchActionC2SPacket.sendPresetListToPlayer(player, workbench);
            }
        });
    }

    private static void sendPresetListToPlayer(ServerPlayer player, CrossbowPresetWorkbenchBlockEntity workbench) {
        workbench.sendPresetListToPlayer(player);
    }

    public static enum Action {
        ENCODE,
        DECODE,
        SAVE,
        LOAD,
        DELETE,
        LOAD_BUILTIN,
        REQUEST_SYNC;

    }
}

