/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.network.packet.C2S;

import com.mafuyu33.mafishcrossbow.MafishCrossbow;
import com.mafuyu33.mafishcrossbow.block.entity.CrossbowTurretBlockEntity;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record TurretBatchConfigC2SPacket(List<BlockPos> turretPositions, ConfigType configType, float value) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TurretBatchConfigC2SPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mafishcrossbow", (String)"turret_batch_config"));
    public static final StreamCodec<FriendlyByteBuf, TurretBatchConfigC2SPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC.apply(ByteBufCodecs.list()), TurretBatchConfigC2SPacket::turretPositions, (StreamCodec)ByteBufCodecs.VAR_INT.map(i -> ConfigType.values()[i], Enum::ordinal), TurretBatchConfigC2SPacket::configType, (StreamCodec)ByteBufCodecs.FLOAT, TurretBatchConfigC2SPacket::value, TurretBatchConfigC2SPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(TurretBatchConfigC2SPacket payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                ServerLevel level = player.level();
                int successCount = 0;
                for (BlockPos pos : payload.turretPositions()) {
                    if (player.blockPosition().distSqr((Vec3i)pos) > 4096.0) {
                        MafishCrossbow.LOGGER.warn("Player {} tried to configure turret at {} but it's too far", (Object)player.getName().getString(), (Object)pos);
                        continue;
                    }
                    BlockEntity patt1$temp = level.getBlockEntity(pos);
                    if (!(patt1$temp instanceof CrossbowTurretBlockEntity)) continue;
                    CrossbowTurretBlockEntity turret = (CrossbowTurretBlockEntity)patt1$temp;
                    if (!player.getUUID().equals(turret.getPlacerUUID())) {
                        MafishCrossbow.LOGGER.warn("Player {} tried to configure turret at {} but they don't own it", (Object)player.getName().getString(), (Object)pos);
                        continue;
                    }
                    boolean success = TurretBatchConfigC2SPacket.applyConfig(turret, payload.configType(), payload.value());
                    if (!success) continue;
                    turret.setChanged();
                    level.sendBlockUpdated(pos, turret.getBlockState(), turret.getBlockState(), 3);
                    ++successCount;
                }
                MafishCrossbow.LOGGER.info("Player {} batch configured {} turrets with {}={}", new Object[]{player.getName().getString(), successCount, payload.configType(), Float.valueOf(payload.value())});
            }
        });
    }

    private static boolean applyConfig(CrossbowTurretBlockEntity turret, ConfigType type, float value) {
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                int mode = (int)value;
                if (mode >= 0 && mode <= 1) {
                    turret.setMode(mode);
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                if (value >= -180.0f && value <= 180.0f) {
                    turret.setFixedYaw(value);
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (value >= -90.0f && value <= 90.0f) {
                    turret.setFixedPitch(value);
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                turret.setEnabled(value != 0.0f);
                yield true;
            }
            case 4 -> {
                int targetType = (int)value;
                if (targetType >= 0 && targetType <= 1) {
                    turret.setTargetType(targetType);
                    yield true;
                }
                yield false;
            }
        };
    }

    public static enum ConfigType {
        MODE,
        FIXED_YAW,
        FIXED_PITCH,
        ENABLED,
        TARGET_TYPE;

    }
}

