/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.network.packet.C2S;

import com.mafuyu33.mafishcrossbow.MafishCrossbow;
import com.mafuyu33.mafishcrossbow.gui.CrossbowTurretMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record TurretConfigC2SPacket(ConfigType configType, float value) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TurretConfigC2SPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mafishcrossbow", (String)"turret_config"));
    public static final StreamCodec<FriendlyByteBuf, TurretConfigC2SPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT.map(i -> ConfigType.values()[i], Enum::ordinal), TurretConfigC2SPacket::configType, (StreamCodec)ByteBufCodecs.FLOAT, TurretConfigC2SPacket::value, TurretConfigC2SPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(TurretConfigC2SPacket payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                AbstractContainerMenu patt1$temp = player.containerMenu;
                if (!(patt1$temp instanceof CrossbowTurretMenu)) {
                    MafishCrossbow.LOGGER.warn("Player {} tried to configure turret but container is not CrossbowTurretMenu", (Object)player.getName().getString());
                    return;
                }
                CrossbowTurretMenu menu = (CrossbowTurretMenu)patt1$temp;
                if (!menu.stillValid((Player)player)) {
                    MafishCrossbow.LOGGER.warn("Player {} tried to configure turret but menu is invalid", (Object)player.getName().getString());
                    return;
                }
                switch (payload.configType().ordinal()) {
                    case 0: {
                        int mode = (int)payload.value();
                        if (mode >= 0 && mode <= 1) {
                            menu.setMode(mode);
                            break;
                        }
                        MafishCrossbow.LOGGER.warn("Invalid mode value: {}", (Object)mode);
                        break;
                    }
                    case 1: {
                        float yaw = payload.value();
                        if (yaw >= -180.0f && yaw <= 180.0f) {
                            menu.setFixedYaw(yaw);
                            break;
                        }
                        MafishCrossbow.LOGGER.warn("Invalid yaw value: {}", (Object)Float.valueOf(yaw));
                        break;
                    }
                    case 2: {
                        float pitch = payload.value();
                        if (pitch >= -90.0f && pitch <= 90.0f) {
                            menu.setFixedPitch(pitch);
                            break;
                        }
                        MafishCrossbow.LOGGER.warn("Invalid pitch value: {}", (Object)Float.valueOf(pitch));
                        break;
                    }
                    case 3: {
                        boolean enabled = payload.value() != 0.0f;
                        menu.setEnabled(enabled);
                        break;
                    }
                    case 4: {
                        int targetType = (int)payload.value();
                        if (targetType >= 0 && targetType <= 1) {
                            menu.setTargetType(targetType);
                            break;
                        }
                        MafishCrossbow.LOGGER.warn("Invalid target type value: {}", (Object)targetType);
                    }
                }
            }
        });
    }

    public static enum ConfigType {
        MODE,
        FIXED_YAW,
        FIXED_PITCH,
        ENABLED,
        TARGET_TYPE;

    }
}

