/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.network.packet.C2S;

import com.mafuyu33.mafishcrossbow.MafishCrossbow;
import com.mafuyu33.mafishcrossbow.block.entity.CrossbowTurretBlockEntity;
import com.mafuyu33.mafishcrossbow.network.packet.S2C.TurretListResponseS2CPacket;
import java.util.ArrayList;
import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record TurretListRequestC2SPacket() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TurretListRequestC2SPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mafishcrossbow", (String)"turret_list_request"));
    public static final StreamCodec<FriendlyByteBuf, TurretListRequestC2SPacket> STREAM_CODEC = StreamCodec.unit((Object)new TurretListRequestC2SPacket());

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(TurretListRequestC2SPacket payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                ServerLevel level = player.level();
                BlockPos playerPos = player.blockPosition();
                ArrayList<TurretListResponseS2CPacket.TurretInfo> turrets = new ArrayList<TurretListResponseS2CPacket.TurretInfo>();
                int scanRange = 128;
                BlockPos.betweenClosed((BlockPos)playerPos.offset(-scanRange, -scanRange, -scanRange), (BlockPos)playerPos.offset(scanRange, scanRange, scanRange)).forEach(pos -> {
                    BlockEntity patt0$temp = level.getBlockEntity(pos);
                    if (patt0$temp instanceof CrossbowTurretBlockEntity) {
                        CrossbowTurretBlockEntity turret = (CrossbowTurretBlockEntity)patt0$temp;
                        if (player.getUUID().equals(turret.getPlacerUUID())) {
                            turrets.add(new TurretListResponseS2CPacket.TurretInfo(pos.immutable(), turret.getMode(), turret.isEnabled(), playerPos.distSqr((Vec3i)pos)));
                        }
                    }
                });
                turrets.sort(Comparator.comparingDouble(TurretListResponseS2CPacket.TurretInfo::distance));
                TurretListResponseS2CPacket response = new TurretListResponseS2CPacket(turrets);
                PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)response, (CustomPacketPayload[])new CustomPacketPayload[0]);
                MafishCrossbow.LOGGER.info("Player {} requested turret list, found {} turrets within {} blocks", new Object[]{player.getName().getString(), turrets.size(), scanRange});
            }
        });
    }
}

