/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu33.mafishcrossbow.network.packet.C2S;

import com.mafuyu33.mafishcrossbow.MafishCrossbow;
import com.mafuyu33.mafishcrossbow.block.entity.CrossbowTurretBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record TurretManualAimC2SPacket(BlockPos turretPos, float yaw, float pitch, boolean isConfirm) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TurretManualAimC2SPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"mafishcrossbow", (String)"turret_manual_aim"));
    public static final StreamCodec<FriendlyByteBuf, TurretManualAimC2SPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, TurretManualAimC2SPacket::turretPos, (StreamCodec)ByteBufCodecs.FLOAT, TurretManualAimC2SPacket::yaw, (StreamCodec)ByteBufCodecs.FLOAT, TurretManualAimC2SPacket::pitch, (StreamCodec)ByteBufCodecs.BOOL, TurretManualAimC2SPacket::isConfirm, TurretManualAimC2SPacket::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(TurretManualAimC2SPacket payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player;
            BlockEntity patt1$temp;
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer && (patt1$temp = (player = (ServerPlayer)patt0$temp).level().getBlockEntity(payload.turretPos())) instanceof CrossbowTurretBlockEntity) {
                CrossbowTurretBlockEntity turretEntity = (CrossbowTurretBlockEntity)patt1$temp;
                if (player.blockPosition().distSqr((Vec3i)payload.turretPos()) > 4096.0) {
                    MafishCrossbow.LOGGER.warn("Player {} tried to configure turret too far away", (Object)player.getName().getString());
                    return;
                }
                float yaw = payload.yaw();
                float pitch = payload.pitch();
                if (yaw < -50.0f || yaw > 50.0f || pitch < -50.0f || pitch > 50.0f) {
                    MafishCrossbow.LOGGER.warn("Player {} sent invalid angle: yaw={}, pitch={}", new Object[]{player.getName().getString(), Float.valueOf(yaw), Float.valueOf(pitch)});
                    return;
                }
                turretEntity.setFixedYaw(yaw);
                turretEntity.setFixedPitch(pitch);
                turretEntity.setTargetYawPitch(yaw, pitch);
                if (payload.isConfirm()) {
                    MafishCrossbow.LOGGER.debug("Player {} confirmed turret aim: yaw={}, pitch={}", new Object[]{player.getName().getString(), Float.valueOf(yaw), Float.valueOf(pitch)});
                }
            }
        });
    }
}

